/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.build;

import org.catacomb.datalish.Box;
import org.catacomb.dataview.build.Displayable;
import org.catacomb.graph.gui.Painter;
import org.catacomb.numeric.data.DataExtractor;

public class DisplayablePoint
extends Displayable {
    public int size;
    double xpt;
    double ypt;
    boolean hasData = false;

    public void markNeeded(DataExtractor dex) {
        String xf = this.x.replaceAll("frame", "-1");
        String yf = this.y.replaceAll("frame", "-1");
        dex.mark(xf);
        dex.mark(yf);
    }

    public void getData(DataExtractor dex, int iframe) {
        String sif = "" + iframe;
        String xf = this.x.replaceAll("frame", sif);
        String yf = this.y.replaceAll("frame", sif);
        this.xpt = dex.getScalar(xf);
        this.ypt = dex.getScalar(yf);
        this.hasData = true;
    }

    public void pushBox(Box b) {
        if (this.hasData) {
            b.extendTo(this.xpt, this.ypt);
        }
    }

    public void instruct(Painter p) {
        if (this.hasData) {
            p.setColor(this.p_color);
            p.fillRectangle(this.xpt, this.ypt, this.p_color, this.size);
        }
    }
}

