/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.build;

import java.util.ArrayList;
import org.catacomb.dataview.build.DVPanel;
import org.catacomb.dataview.build.DataSource;
import org.catacomb.dataview.build.FrameSelector;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.gui.base.DruAppletPrep;
import org.catacomb.druid.gui.base.DruApplication;
import org.catacomb.druid.gui.base.DruBorderPanel;
import org.catacomb.druid.gui.base.DruBoxPanel;
import org.catacomb.druid.gui.base.DruFrame;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.interlish.structure.AddableTo;
import org.catacomb.report.E;

public class Dataview
implements AddableTo {
    public int width;
    public int height;
    public DataSource dataSource;
    public FrameSelector frameSelector;
    public String layout;
    public String name;
    public ArrayList<DVPanel> panels;

    public void add(Object obj) {
        if (obj instanceof DVPanel) {
            if (this.panels == null) {
                this.panels = new ArrayList();
            }
            this.panels.add((DVPanel)obj);
        } else {
            E.debugError("dataview - cant add " + obj + " (" + obj.getClass().getName() + ")");
        }
    }

    public void show() {
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DruApplication buildApplication(Context ctxt) {
        DruApplication druapp = new DruApplication();
        druapp.setName("data viewer");
        DruFrame druf = new DruFrame("data viewer");
        druf.setBackgroundColor(ctxt.getBg());
        druf.setDruPanel(this.makePanel(ctxt));
        druapp.setMainFrame(druf);
        return druapp;
    }

    public DruAppletPrep buildAppletPrep(Context ctxt) {
        DruAppletPrep druapp = new DruAppletPrep();
        druapp.setDruPanel(this.makePanel(ctxt));
        return druapp;
    }

    public DruPanel makePanel(Context ctxt) {
        DruBorderPanel dbp = new DruBorderPanel();
        dbp.setBg(ctxt.getBg());
        dbp.setFg(ctxt.getFg());
        DruPanel mainPanel = null;
        int np = this.panels.size();
        if (np == 1) {
            mainPanel = this.makeIthPanel(ctxt, 0);
            dbp.addCenter(mainPanel);
        } else {
            DruBoxPanel drubp = null;
            drubp = this.layout != null && this.layout.equals("vertical") ? new DruBoxPanel(1, 0) : new DruBoxPanel(2, 0);
            drubp.setBg(ctxt.getBg());
            drubp.setFg(ctxt.getFg());
            int i = 0;
            while (i < this.panels.size()) {
                DruPanel dp = this.makeIthPanel(ctxt, i);
                drubp.addPanel(dp);
                ++i;
            }
            dbp.addCenter(drubp);
            mainPanel = drubp;
        }
        mainPanel.setID("main");
        ctxt.addToCache(mainPanel);
        if (this.frameSelector != null) {
            DruPanel drufp = this.frameSelector.makePanel(ctxt);
            dbp.addSouth(drufp);
        }
        dbp.addBorder(6, 6, 6, 6);
        return dbp;
    }

    private DruPanel makeIthPanel(Context ctxt, int ipan) {
        DVPanel dvp = this.panels.get(ipan);
        DruPanel drup = dvp.makePanel(ctxt);
        drup.addBorder(4, 4, 4, 4);
        return drup;
    }
}

