/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import org.catacomb.dataview.DataPlotPainter;
import org.catacomb.dataview.FrameController;
import org.catacomb.dataview.build.DataSource;
import org.catacomb.dataview.build.Dataview;
import org.catacomb.dataview.read.ContentReader;
import org.catacomb.dataview.read.Exporter;
import org.catacomb.dataview.read.FUImportContext;
import org.catacomb.druid.gui.base.DruFrame;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.interlish.service.Env;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.interlish.structure.GraphicsView;
import org.catacomb.interlish.structure.ModeSetter;
import org.catacomb.numeric.data.DataExtractor;
import org.catacomb.numeric.data.NumDataSet;
import org.catacomb.report.E;
import org.catacomb.serial.jar.CustomJarWriter;
import org.catacomb.util.AWTUtil;
import org.catacomb.util.ImageUtil;

public class DataviewController
implements Controller {
    Dataview dataview;
    int npainter;
    DataPlotPainter[] painters;
    int ndisplay;
    GraphicsView[] displays;
    FrameController frameController;
    DruFrame mainFrame;
    DruPanel mainPanel;
    DataExtractor dataExtractor;
    ContentReader contentReader;
    String datsrc = "";

    public DataviewController(Dataview dv) {
        this.dataview = dv;
    }

    public void initData(ContentReader dsr) {
        this.contentReader = dsr;
        this.dataExtractor = new DataExtractor();
        this.initDataSource();
        this.exportData();
        if (Env.isApplication()) {
            this.cacheBinary();
        }
    }

    public void setMainFrame(DruFrame df) {
        this.mainFrame = df;
    }

    public void exit() {
        this.mainFrame.dispose();
    }

    public void attached() {
    }

    public void cacheBinary() {
        FUImportContext ctxt = this.contentReader.getContext();
        File fsrc = ctxt.getSourceFile();
        String cbin = ctxt.getExtensionRelativeName("-cache.bnd");
        File fbin = ctxt.getRelativeFile(cbin);
        String cjar = ctxt.getExtensionRelativeName("sdj");
        File fjar = ctxt.getRelativeFile(cjar);
        if (fbin != null && !fbin.exists()) {
            DataSource ds = this.dataview.getDataSource();
            String datname = ds.name;
            NumDataSet omin = this.getMinimalDataSet(datname);
            Exporter.export(omin, fbin);
        }
        if (fsrc != null && fsrc.getName().endsWith("xml")) {
            CustomJarWriter jarw = new CustomJarWriter();
            jarw.addMain(fsrc);
            jarw.add(fbin);
            jarw.write(fjar);
        }
    }

    public void cacheData(File fcache, String cnm) {
    }

    private void initDataSource() {
        DataSource ds = this.dataview.getDataSource();
        String fnm = ds.file;
        Object dataobj = null;
        FUImportContext ctxt = this.contentReader.getContext();
        String cca = ctxt.getExtensionRelativeName("-cache.bnd");
        if (cca != null && ctxt.hasRelative(cca)) {
            dataobj = ctxt.getRelative(cca);
        } else if (fnm != null && ctxt.hasRelative(fnm)) {
            dataobj = ctxt.getRelative(fnm);
        }
        if (dataobj instanceof NumDataSet) {
            NumDataSet dataSet = (NumDataSet)dataobj;
            dataSet.setName(ds.name);
            this.dataExtractor.addDataSet(dataSet);
        } else {
            E.error("Dataview controller - wrong data type " + dataobj);
        }
    }

    public void setDisplays(ArrayList arl) {
        this.displays = new GraphicsView[10];
        this.ndisplay = 0;
        this.painters = new DataPlotPainter[10];
        this.npainter = 0;
        for (Object obj : arl) {
            if (obj instanceof GraphicsView) {
                this.displays[this.ndisplay++] = (GraphicsView)obj;
            } else if (obj instanceof DataPlotPainter) {
                this.painters[this.npainter++] = (DataPlotPainter)obj;
            } else if (obj instanceof FrameController) {
                this.frameController = (FrameController)obj;
                this.frameController.setDataviewController(this);
            } else if (obj instanceof ModeSetter) {
                E.missing();
            } else if (!(obj instanceof DruPanel) || !((DruPanel)obj).getID().equals("main")) {
                E.error("dataview controller cant handle display item " + obj);
            }
            if (!(obj instanceof DruPanel) || !((DruPanel)obj).getID().equals("main")) continue;
            this.mainPanel = (DruPanel)obj;
        }
    }

    private void setPaintWidthFactor(int ithick) {
        int i = 0;
        while (i < this.npainter) {
            this.painters[i].setPaintWidthFactor(ithick);
            ++i;
        }
    }

    private void exportData() {
        int i = 0;
        while (i < this.npainter) {
            this.painters[i].setDataSource(this.dataExtractor);
            ++i;
        }
        if (this.frameController != null) {
            this.frameController.setDataSource(this.dataExtractor);
        }
        this.updateDisplays();
    }

    private void markNeeded() {
        int i = 0;
        while (i < this.npainter) {
            this.painters[i].markNeeded();
            ++i;
        }
        if (this.frameController != null) {
            this.frameController.markNeeded();
        }
    }

    public void setMode(String dom, String mod) {
        E.missing("cant set mode from here");
        int i = 0;
        while (i < this.ndisplay) {
            ++i;
        }
    }

    public void showFrame(int iframe) {
        int i = 0;
        while (i < this.npainter) {
            this.painters[i].showFrame(iframe);
            ++i;
        }
        this.updateDisplays();
    }

    private void updateDisplays() {
        int i = 0;
        while (i < this.ndisplay) {
            this.displays[i].viewChanged();
            ++i;
        }
    }

    public void requestClose() {
        E.missing();
        this.requestExit();
    }

    public void requestExit() {
        E.missing();
        System.exit(0);
    }

    public BufferedImage getBufferedImage(int ithick) {
        this.setPaintWidthFactor(ithick);
        BufferedImage ret = AWTUtil.getBufferedImage(this.mainPanel);
        this.setPaintWidthFactor(1);
        return ret;
    }

    private NumDataSet getMinimalDataSet(String datname) {
        this.markNeeded();
        NumDataSet nds = this.dataExtractor.getDataSet(datname);
        NumDataSet ret = nds.copyMarked();
        return ret;
    }

    public void saveImage(File file, int ifr) {
        this.showFrame(ifr);
        BufferedImage bim = this.getBufferedImage(1);
        ImageUtil.writePNG(bim, file);
    }

    public void saveThumbnailImage(File file, int ifr) {
        this.showFrame(ifr);
        BufferedImage bim = this.getBufferedImage(1);
        int wscl = 140;
        int hscl = 140;
        int wf = bim.getWidth();
        int hf = bim.getHeight();
        double fo = (float)wscl / (float)hscl;
        double ff = (float)wf / (float)hf;
        if (ff > fo) {
            hscl = (int)((double)wscl / ff);
        } else {
            wscl = (int)((double)hscl * ff);
        }
        int ithick = (wf + wscl / 2) / wscl;
        bim = this.getBufferedImage(ithick);
        BufferedImage bufim = AWTUtil.getScaledBufferedImage(bim, wscl, hscl);
        ImageUtil.writePNG(bufim, file);
    }

    public void makeMovie(File f) {
        if (this.frameController != null) {
            this.frameController.makeMovie(f);
        } else {
            E.error("no frame controller - cant make movie");
        }
    }

    public void makeThumbnailMovie(File f) {
        if (this.frameController != null) {
            this.frameController.makeThumbnailMovie(f);
        } else {
            E.error("no frame controller - cant make movie");
        }
    }
}

