/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview;

import java.util.ArrayList;
import org.catacomb.datalish.Box;
import org.catacomb.dataview.build.Displayable;
import org.catacomb.dataview.build.Line;
import org.catacomb.graph.gui.Labellee;
import org.catacomb.graph.gui.Labeller;
import org.catacomb.graph.gui.PaintInstructor;
import org.catacomb.graph.gui.Painter;
import org.catacomb.numeric.data.DataExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPlotPainter
implements PaintInstructor {
    ArrayList displayList;
    DataExtractor dataExtractor;
    Displayable[] items;
    int currentFrame;
    Box limitBox;
    Labeller labeller;
    int widthFactor = 1;

    public DataPlotPainter(ArrayList<Displayable> arl) {
        if (arl == null) {
            this.items = new Displayable[0];
        } else {
            int n = arl.size();
            this.items = new Displayable[n];
            int iit = 0;
            for (Displayable dbl : arl) {
                this.items[iit++] = dbl;
            }
        }
    }

    public void setPaintWidthFactor(int ithick) {
        this.widthFactor = ithick;
    }

    public void markNeeded() {
        int i = 0;
        while (i < this.items.length) {
            this.items[i].markNeeded(this.dataExtractor);
            ++i;
        }
    }

    public void setDataSource(DataExtractor dex) {
        this.currentFrame = -1;
        this.dataExtractor = dex;
        this.showFrame(0);
    }

    public void showFrame(int iframe) {
        int i;
        if (iframe != this.currentFrame && this.dataExtractor != null) {
            this.currentFrame = iframe;
            i = 0;
            while (i < this.items.length) {
                this.items[i].getData(this.dataExtractor, this.currentFrame);
                boolean cfr_ignored_0 = this.items[i] instanceof Line;
                ++i;
            }
        }
        this.makeLims();
        if (this.labeller == null) {
            this.labeller = new Labeller(this.items.length);
            i = 0;
            while (i < this.items.length) {
                Line ll;
                Labellee lle;
                if (this.items[i] instanceof Line && (lle = (ll = (Line)this.items[i]).getLabellee()) != null) {
                    this.labeller.updateLabellee(i, lle);
                }
                ++i;
            }
            this.labeller.initLabels(this.limitBox);
        } else {
            this.labeller.adjustLabels(this.limitBox);
        }
    }

    private void makeLims() {
        Box limits = new Box();
        int i = 0;
        while (i < this.items.length) {
            this.items[i].pushBox(limits);
            ++i;
        }
        limits.pad();
        this.limitBox = limits;
    }

    @Override
    public Box getLimitBox() {
        this.makeLims();
        return this.limitBox;
    }

    @Override
    public boolean antialias() {
        return true;
    }

    @Override
    public void instruct(Painter p) {
        int i = 0;
        while (i < this.items.length) {
            this.items[i].instruct(p, this.widthFactor);
            ++i;
        }
        if (this.labeller != null) {
            this.labeller.instruct(p);
        }
    }
}

