/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview;

import java.awt.GridLayout;
import java.net.URL;
import javax.swing.JApplet;
import org.catacomb.dataview.DataviewController;
import org.catacomb.dataview.build.Dataview;
import org.catacomb.dataview.read.ContentReader;
import org.catacomb.dataview.read.Importer;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.gui.base.DruAppletPrep;
import org.catacomb.interlish.service.Env;
import org.catacomb.report.E;

public class AppletDataViewer
extends JApplet {
    static final long serialVersionUID = 1001L;

    public AppletDataViewer() {
        Env.setContextApplet();
    }

    public void init() {
        String config = this.getParameter("config");
        E.info("got config parameter " + config);
        try {
            URL confurl = new URL(this.getCodeBase(), config);
            ContentReader dsr = Importer.getReader(confurl);
            E.info("should be getting url " + confurl.toString());
            Object obj = dsr.getMain();
            Dataview dv = (Dataview)obj;
            Context ctxt = new Context();
            DruAppletPrep druapp = dv.buildAppletPrep(ctxt);
            this.getContentPane().setLayout(new GridLayout(1, 1));
            this.getContentPane().add(druapp.getDruPanel().getGUIPeer());
            DataviewController dvc = new DataviewController(dv);
            dvc.setDisplays(ctxt.getCache());
            dvc.initData(dsr);
        }
        catch (Exception ex) {
            E.error("cant init applet " + ex);
        }
    }
}

