/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.datalish;

import java.awt.Color;
import org.catacomb.be.DeReferencable;
import org.catacomb.be.ReReferencable;
import org.catacomb.datalish.ColorNames;
import org.catacomb.report.E;

public class SColor
implements DeReferencable,
ReReferencable {
    public String string;
    private Color p_color;

    public SColor() {
        this.p_color = Color.red;
    }

    public SColor(String s) {
        this.string = s;
        this.p_color = SColor.parseColor(s);
    }

    public SColor(Color c) {
        this.p_color = c;
    }

    public String toString() {
        return SColor.serializeColor(this.p_color);
    }

    public void deReference() {
        this.string = SColor.serializeColor(this.p_color);
    }

    public void reReference() {
        this.p_color = SColor.parseColor(this.string);
    }

    public Color getColor() {
        return this.p_color;
    }

    public static Color parseColor(String s) {
        Color cret = null;
        if (!(s = s.trim()).startsWith("#")) {
            s = ColorNames.getHexValue(s);
        }
        if (s == null) {
            E.error("cant get color " + s);
        } else {
            try {
                int ic = Integer.decode(s);
                cret = new Color(ic);
            }
            catch (NumberFormatException ex) {
                E.error(" - cant decode color string " + s);
                cret = Color.red;
            }
        }
        return cret;
    }

    public static String serializeColor(Color c) {
        int rgb = c.getRGB();
        int xrgb = rgb | 0xFF0000;
        String fullhex = Integer.toHexString(xrgb);
        String ret = "#" + fullhex.substring(2, 8);
        return ret;
    }
}

