/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.datalish;

import org.catacomb.be.Position;

public final class Box {
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    double subdivDx;
    double subdivDy;
    private boolean noXdata;
    private boolean noYdata;

    public Box(Position p) {
        this(p.getX(), p.getY());
    }

    public Box(double x, double y) {
        this.xmin = x;
        this.xmax = x;
        this.ymin = y;
        this.ymax = y;
        this.noXdata = false;
        this.noYdata = false;
    }

    public Box() {
        this.noXdata = true;
        this.noYdata = true;
    }

    public Box(double x0, double y0, double x1, double y1) {
        this.xmin = x0;
        this.ymin = y0;
        this.xmax = x1;
        this.ymax = y1;
        this.noXdata = false;
        this.noYdata = false;
    }

    public Box makeCopy() {
        return new Box(this.xmin, this.ymin, this.xmax, this.ymax);
    }

    public String toString() {
        return " Box x0=" + this.xmin + " y0=" + this.ymin + " x1=" + this.xmax + " y1=" + this.xmax;
    }

    public void setXMin(double d) {
        this.xmin = d;
    }

    public void setXMax(double d) {
        this.xmax = d;
    }

    public void setYMin(double d) {
        this.ymin = d;
    }

    public void setYMax(double d) {
        this.ymax = d;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public void subdivide(int n) {
        this.subdivDx = (this.xmax - this.xmin) / (double)n;
        this.subdivDy = (this.ymax - this.ymin) / (double)n;
    }

    public int getXSubdivision(double x) {
        int ret = (int)((x - this.xmin) / this.subdivDx);
        return ret;
    }

    public int getYSubdivision(double y) {
        int ret = (int)((y - this.ymin) / this.subdivDy);
        return ret;
    }

    public int getXSubdivision(double x, int n) {
        double dx = (this.xmax - this.xmin) / (double)n;
        int ret = (int)((x - this.xmin) / dx);
        return ret;
    }

    public int getYSubdivision(double y, int n) {
        double dy = (this.ymax - this.ymin) / (double)n;
        int ret = (int)((y - this.ymin) / dy);
        return ret;
    }

    public void extendTo(Position p) {
        this.extendTo(p.getX(), p.getY());
    }

    public void extendTo(Box b) {
        this.extendTo(b.xmin, b.ymin);
        this.extendTo(b.xmax, b.ymax);
    }

    public void extendTo(double[] xp, double[] yp) {
        int i = 0;
        while (i < xp.length) {
            this.extendTo(xp[i], yp[i]);
            ++i;
        }
    }

    public boolean hasData() {
        return !this.noXdata && !this.noYdata;
    }

    public void extendXTo(double x) {
        if (this.noXdata) {
            this.xmin = x;
            this.xmax = x;
            this.noXdata = false;
        }
        if (x < this.xmin) {
            this.xmin = x;
        }
        if (x > this.xmax) {
            this.xmax = x;
        }
    }

    public void extendTo(double x, double y) {
        this.extendXTo(x);
        this.extendYTo(y);
    }

    public void extendYTo(double y) {
        if (this.noYdata) {
            this.ymin = y;
            this.ymax = y;
            this.noYdata = false;
        }
        if (y < this.ymin) {
            this.ymin = y;
        }
        if (y > this.ymax) {
            this.ymax = y;
        }
    }

    public void pad() {
        this.enlarge(0.1);
    }

    public void enlarge(double f) {
        double dx = f * (this.xmax - this.xmin);
        double dy = f * (this.ymax - this.ymin);
        this.xmin -= dx;
        this.xmax += dx;
        this.ymin -= dy;
        this.ymax += dy;
    }

    public void push(double[] x, double[] y) {
        this.pushX(x, x.length);
        this.pushY(y, y.length);
    }

    public void pushX(double[] v, int np) {
        if (np > 0 && this.noXdata) {
            this.xmin = v[0];
            this.xmax = v[0];
            this.noXdata = false;
        }
        int i = 0;
        while (i < np) {
            double d = v[i];
            if (this.xmin > d) {
                this.xmin = d;
            }
            if (this.xmax < d) {
                this.xmax = d;
            }
            ++i;
        }
    }

    public void pushY(double[] v, int np) {
        if (np > 0 && this.noYdata) {
            this.ymin = v[0];
            this.ymax = v[0];
            this.noYdata = false;
        }
        int i = 0;
        while (i < np) {
            double d = v[i];
            if (this.ymin > d) {
                this.ymin = d;
            }
            if (this.ymax < d) {
                this.ymax = d;
            }
            ++i;
        }
    }

    public void push(Position position) {
        this.extendTo(position.getX(), position.getY());
    }

    public boolean differentFrom(Box b, double d) {
        boolean ret = false;
        if (this.hasData() && b.hasData() && (this.rangesDiffer(this.xmin, this.xmax, b.xmin, b.xmax, d) || this.rangesDiffer(this.ymin, this.ymax, b.ymin, b.ymax, d))) {
            ret = true;
        }
        return ret;
    }

    private boolean rangesDiffer(double a, double b, double c, double d, double delta) {
        boolean ret = false;
        double u = 0.5 * (b - a + d - c);
        double f1 = (c - a) / u;
        double f2 = (d - b) / u;
        ret = Math.abs(f1) > delta || Math.abs(f2) > delta;
        return ret;
    }

    public Position getCenter() {
        double cx = 0.5 * (this.xmin + this.xmax);
        double cy = 0.5 * (this.ymin + this.ymax);
        return new Position(cx, cy);
    }

    public double getRadius() {
        double dx = this.xmax - this.xmin;
        double dy = this.ymax - this.ymin;
        double scl = 0.5 * Math.max(dx, dy);
        return scl;
    }

    public void tidyLimits() {
        if (this.xmin > 0.0 && (this.xmax - this.xmin) / this.xmin > 5.0) {
            this.xmin = 0.0;
        } else if (this.xmin < 0.0 && (this.xmax - this.xmin) / -this.xmin > 20.0) {
            this.xmin = 0.0;
        }
        if (this.ymin > 0.0 && (this.ymax - this.ymin) / this.ymin > 5.0) {
            this.ymin = 0.0;
        } else if (this.ymin < 0.0 && (this.ymax - this.ymin) / -this.ymin > 20.0) {
            this.ymin = 0.0;
        }
    }
}

