/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.be;

import org.catacomb.be.Direction;
import org.catacomb.be.XYLocation;
import org.catacomb.report.E;

public final class Position
implements XYLocation {
    double x;
    double y;
    boolean valid;

    public Position() {
        this(999.9, 999.9);
        this.valid = false;
    }

    public Position(XYLocation p) {
        this.set(p.getX(), p.getY());
    }

    public Position(double px, double py) {
        this.set(px, py);
    }

    public String toString() {
        return "position(" + this.x + ", " + this.y + ")";
    }

    public void set(XYLocation p) {
        this.set(p.getX(), p.getY());
    }

    public void add(Position p) {
        this.reportInValid();
        this.x += p.getX();
        this.y += p.getY();
    }

    public void subtract(Position p) {
        this.reportInValid();
        this.x -= p.getX();
        this.y -= p.getY();
    }

    public void absolutize(Position porig, double scale, Position prel) {
        this.set(porig.getX() + scale * prel.getX(), porig.getY() + scale * prel.getY());
    }

    public void relativize(Position porig, double scale, Position pabs) {
        this.set((pabs.getX() - porig.getX()) / scale, (pabs.getY() - porig.getY()) / scale);
    }

    private void reportInValid() {
        if (!this.valid) {
            E.warning("using a default position? " + this.x + " " + this.y);
        }
    }

    public void set(double px, double py) {
        this.x = px;
        this.y = py;
        this.valid = true;
    }

    public double getX() {
        this.reportInValid();
        return this.x;
    }

    public double getY() {
        this.reportInValid();
        return this.y;
    }

    public static Position aXPlusBY(double a, Position v, double b, Position w) {
        Position ret = new Position(a * v.getX() + b * w.getX(), a * v.getY() + b * w.getY());
        return ret;
    }

    public void shift(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public void shift(Position spos) {
        this.x += spos.getX();
        this.y += spos.getY();
    }

    public boolean isValid() {
        return this.valid;
    }

    public Position copy() {
        return new Position(this);
    }

    public double distanceFrom(Position p) {
        double dx = p.getX() - this.x;
        double dy = p.getY() - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distanceFromOrigin() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Position getRelativeToBoxCenter(double[] xyxy) {
        double cx = (xyxy[2] + xyxy[0]) / 2.0;
        double dx = (xyxy[2] - xyxy[0]) / 2.0;
        double cy = (xyxy[3] + xyxy[1]) / 2.0;
        double dy = (xyxy[3] - xyxy[1]) / 2.0;
        return new Position((this.x - cx) / dx, (this.y - cy) / dy);
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public static Position midpoint(Position pa, Position pb) {
        return new Position(0.5 * (pa.x + pb.x), 0.5 * (pa.y + pb.y));
    }

    public void rotateBy(double rad) {
        double c = Math.cos(rad);
        double s = Math.sin(rad);
        this.rotateCosSin(c, s);
    }

    private void rotateCosSin(double c, double s) {
        double xr = c * this.x - s * this.y;
        double yr = s * this.x + c * this.y;
        this.x = xr;
        this.y = yr;
    }

    public void rotateTo(Direction dir) {
        double c = dir.getCosine();
        double s = dir.getSine();
        this.rotateCosSin(c, s);
    }

    public void rotateAbout(Position pcen, double rad) {
        double c = Math.cos(rad);
        double s = Math.sin(rad);
        double cx = pcen.getX();
        double cy = pcen.getY();
        double dx = this.x - cx;
        double dy = this.y - cy;
        this.x = cx + c * dx - s * dy;
        this.y = cy + s * dx + c * dy;
    }
}

