/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUtil {
    public static byte[] readHeader(File f, int n) {
        byte[] ret = null;
        try {
            FileInputStream ins = new FileInputStream(f);
            ret = new byte[n];
            int nread = ins.read(ret);
            if (nread != n) {
                E.error("readNBytes wanted " + n + " but got " + nread);
            }
            ins.close();
        }
        catch (Exception ex) {
            E.error("readNBytes problem " + ex);
        }
        return ret;
    }

    public static byte[] readBytes(File f) {
        byte[] ret = null;
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bb = new byte[4096];
            int nread = bis.read(bb);
            while (nread > 0) {
                baos.write(bb, 0, nread);
                nread = bis.read(bb);
            }
            ret = baos.toByteArray();
        }
        catch (Exception ex) {
            E.error("readNBytes problem " + ex);
        }
        return ret;
    }

    public static String readStringFromFile(File f) {
        String sdat = "null";
        if (f != null) {
            try {
                boolean dogz = f.getName().endsWith(".gz");
                InputStream ins = new FileInputStream(f);
                if (dogz) {
                    ins = new GZIPInputStream(ins);
                }
                InputStreamReader insr = new InputStreamReader(ins);
                BufferedReader fr = new BufferedReader(insr);
                StringBuffer sb = new StringBuffer();
                while (fr.ready()) {
                    sb.append(fr.readLine());
                    sb.append("\n");
                }
                fr.close();
                sdat = sb.toString();
            }
            catch (IOException ex) {
                E.error("Cant read file " + f);
            }
        }
        return sdat;
    }

    public static boolean writeStringToFile(String sdat, File f) {
        String fnm = f.getName();
        boolean ok = false;
        if (f != null) {
            boolean dogz = fnm.endsWith(".gz");
            try {
                OutputStream fos = new FileOutputStream(f);
                if (dogz) {
                    fos = new GZIPOutputStream(fos);
                }
                OutputStreamWriter osw = new OutputStreamWriter(fos);
                osw.write(sdat, 0, sdat.length());
                osw.close();
                ok = true;
            }
            catch (IOException ex) {
                E.error("file writing error, trying to write file " + fnm);
                ex.printStackTrace();
            }
        }
        return ok;
    }

    public static String getRootName(File f) {
        String fnm = f.getName();
        String root = fnm.substring(0, fnm.lastIndexOf("."));
        return root;
    }

    public static void writeBytes(byte[] ba, File f) {
        FileUtil.writeByteArrayToFile(ba, f);
    }

    public static void writeByteArrayToFile(byte[] ba, File f) {
        if (f == null) {
            return;
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            ((OutputStream)os).write(ba);
            ((OutputStream)os).flush();
        }
        catch (Exception e) {
            E.error("cant write byte array " + ba + " to " + f);
        }
    }

    public static void copyFile(File fsrc, File fdest) {
        if (fsrc.exists()) {
            try {
                int len;
                FileInputStream in = new FileInputStream(fsrc);
                FileOutputStream out = new FileOutputStream(fdest);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (Exception ex) {
                E.error("file copy exception");
            }
        } else {
            E.warning("copy - missing file " + fsrc);
        }
    }

    public static String findPath(File f, String name) {
        String ret = null;
        File[] fileArray = f.listFiles();
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File fs = fileArray[n];
            if (fs.getName().equals(name)) {
                ret = "";
                break;
            }
            ++n;
        }
        if (ret == null) {
            fileArray = f.listFiles();
            n = 0;
            n2 = fileArray.length;
            while (n < n2) {
                String s;
                File fd = fileArray[n];
                if (fd.isDirectory() && (s = FileUtil.findPath(fd, name)) != null) {
                    if (s.equals("")) {
                        ret = fd.getName();
                        break;
                    }
                    ret = String.valueOf(fd.getName()) + "/" + s;
                    break;
                }
                ++n;
            }
        }
        return ret;
    }

    public static String readFirstLine(File f) {
        String ret = null;
        if (f != null) {
            try {
                FileInputStream ins = new FileInputStream(f);
                InputStreamReader insr = new InputStreamReader(ins);
                BufferedReader fr = new BufferedReader(insr);
                ret = fr.readLine();
                fr.close();
            }
            catch (IOException ex) {
                E.error("file read error ");
                ex.printStackTrace();
            }
        }
        return ret;
    }

    public static String getRelativeDirectory(File ftgt, File rtFolder) {
        int ns = 0;
        String sret = null;
        for (File fpar = ftgt.getParentFile(); fpar != null && !fpar.equals(rtFolder); fpar = fpar.getParentFile()) {
            sret = sret == null ? fpar.getName() : String.valueOf(fpar.getName()) + "/" + sret;
            if (++ns <= 8) continue;
            E.error("too many steps trying to get relative files ? " + ftgt.getAbsolutePath() + " " + rtFolder.getAbsolutePath());
            break;
        }
        return sret;
    }

    public static ArrayList<File> matchingFiles(String srcPattern) {
        ArrayList<File> ret;
        block4: {
            block3: {
                ret = new ArrayList<File>();
                if (srcPattern.indexOf("*") >= 0) break block3;
                File fd = new File(srcPattern);
                if (!fd.exists() || !fd.isDirectory()) break block4;
                File[] fileArray = fd.listFiles();
                int n = 0;
                int n2 = fileArray.length;
                while (n < n2) {
                    File f = fileArray[n];
                    ret.add(f);
                    ++n;
                }
                break block4;
            }
            int istar = srcPattern.indexOf("*");
            String sa = srcPattern.substring(0, istar);
            String sb = srcPattern.substring(istar + 1, srcPattern.length());
            File ftop = new File(sa);
            File[] fileArray = ftop.listFiles();
            int n = 0;
            int n3 = fileArray.length;
            while (n < n3) {
                File fg = fileArray[n];
                File fp = new File(fg, sb);
                if (fp.exists()) {
                    ret.add(fp);
                }
                ++n;
            }
        }
        return ret;
    }

    public static void deleteDir(File fdir) {
        File[] fileArray = fdir.listFiles();
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File f = fileArray[n];
            if (f.isDirectory()) {
                FileUtil.deleteDir(f);
            } else {
                f.delete();
            }
            ++n;
        }
        fdir.delete();
    }

    public static File getTempFolder() {
        String s = System.getProperty("java.io.tmpdir");
        File fsystmp = new File(s);
        long l = System.currentTimeMillis();
        File ftmp = new File(fsystmp, "ccmb" + l);
        ftmp.mkdir();
        return ftmp;
    }

    public static void clearCache(File fparam) {
        File fcls;
        String fnm = fparam.getName();
        int ild = fnm.lastIndexOf(".");
        if (ild > 0 && (fcls = new File(fparam.getParent(), String.valueOf(fnm.substring(0, ild)) + ".class")).exists()) {
            fcls.delete();
        }
    }

    public static File getSiblingFile(File fme, String ext) {
        String fnm = fme.getName();
        int ild = fnm.lastIndexOf(".");
        if (ild > 1) {
            fnm = fnm.substring(0, ild);
        }
        File fret = new File(fme.getParentFile(), String.valueOf(fnm) + ext);
        return fret;
    }

    public static ArrayList<String> getPathElements(File rootDir, File ftgt) {
        ArrayList<String> elts = new ArrayList<String>();
        int ns = 0;
        Object sret = null;
        for (File fpar = ftgt.getParentFile(); fpar != null && !fpar.equals(rootDir); fpar = fpar.getParentFile()) {
            elts.add(0, fpar.getName());
            if (++ns <= 8) continue;
            E.error("too many steps trying to get relative files ? " + ftgt.getAbsolutePath() + " " + rootDir.getAbsolutePath());
            break;
        }
        return elts;
    }
}

