/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import org.catacomb.report.E;

public class AWTUtil {
    public static BufferedImage getScaledBufferedImage(Image srcim, int wscl, int hscl) {
        BufferedImage imret = new BufferedImage(wscl, hscl, 5);
        Image sim = srcim.getScaledInstance(wscl, hscl, 16);
        Graphics gg = imret.getGraphics();
        gg.drawImage(sim, 0, 0, null);
        return imret;
    }

    public static BufferedImage getBufferedImage(Object ob) {
        return AWTUtil.getBufferedImage(ob, 1.0);
    }

    public static BufferedImage getBufferedImage(Object ob, double f) {
        Component fr = (Component)ob;
        Dimension d = fr.getSize();
        int imw = d.width;
        int imh = d.height;
        BufferedImage im = new BufferedImage(imw, imh, 5);
        Graphics gg = im.getGraphics();
        fr.paint(gg);
        return im;
    }

    public static Image getImage(Object ob) {
        return AWTUtil.getImage(ob, 1.0);
    }

    public static Image getImage(Object ob, double f) {
        if (!(ob instanceof Image) && !(ob instanceof Component)) {
            E.error("cant get image of " + ob);
            return null;
        }
        Image im = null;
        if (ob instanceof Image) {
            im = (Image)ob;
        } else {
            Component fr = (Component)ob;
            Dimension d = fr.getSize();
            int imw = d.width;
            int imh = d.height;
            im = fr.createImage(imw, imh);
            Graphics gg = im.getGraphics();
            fr.paint(gg);
        }
        int imw = im.getWidth(null);
        int imh = im.getHeight(null);
        if (Math.abs(f - 1.0) > 0.001) {
            imw = (int)(f * (double)imw);
            imh = (int)(f * (double)imh);
            im = im.getScaledInstance(imw, imh, 16);
        }
        return im;
    }

    public static int[][] getIntegerImage(Object ob) {
        return AWTUtil.getIntegerImage(ob, 1.0);
    }

    public static int[][] getIntegerImage(Object ob, double f) {
        Image img = AWTUtil.getImage(ob, f);
        int imw = img.getWidth(null);
        int imh = img.getHeight(null);
        int[] pix = new int[imw * imh];
        PixelGrabber grabber = new PixelGrabber(img, 0, 0, imw, imh, pix, 0, imw);
        try {
            grabber.grabPixels();
        }
        catch (Exception e) {
            E.error("pixel grabbing interrupted");
        }
        int[][] ret = new int[imh][imw];
        int i = 0;
        while (i < imh) {
            int j = 0;
            while (j < imw) {
                int pi = pix[i * imw + j];
                int ir = pi >> 16 & 0xFF;
                int ig = pi >> 8 & 0xFF;
                int ib = pi & 0xFF;
                ret[i][j] = (ir << 16) + (ig << 8) + ib;
                if (ret[i][j] < 0) {
                    E.error("neg pix value??  " + ret[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }
}

