/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.serial;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import org.catacomb.be.DeReferencable;
import org.catacomb.interlish.structure.Attribute;
import org.catacomb.interlish.structure.Element;
import org.catacomb.interlish.structure.Stateless;
import org.catacomb.report.E;
import org.catacomb.serial.OmElementizer;
import org.catacomb.serial.SerialUtil;
import org.catacomb.serial.SerializationContext;
import org.catacomb.serial.om.OmAttribute;
import org.catacomb.serial.om.OmElement;

public class Reflector {
    public static Element makeObjectElementByReflection(Object obj, OmElementizer elementizer) {
        String ss;
        SerializationContext ctxt = elementizer.getContext();
        if (obj instanceof DeReferencable) {
            ((DeReferencable)obj).deReference();
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        ArrayList<Element> elements = new ArrayList<Element>();
        String scnm = obj.getClass().getName();
        int ild = scnm.lastIndexOf(".");
        String spk = scnm.substring(0, ild);
        String eltname = ss = scnm.substring(ild + 1, scnm.length());
        if (elementizer.getContext().shouldWritePackage(spk)) {
            attributes.add(new OmAttribute("package", spk));
        }
        ArrayList<AccessibleObject> af = new ArrayList<AccessibleObject>();
        Class<?> cls = obj.getClass();
        do {
            AccessibleObject[] accessibleObjectArray;
            AccessibleObject[] accessibleObjectArray2 = accessibleObjectArray = cls.getDeclaredFields();
            int n = 0;
            int n2 = accessibleObjectArray2.length;
            while (n < n2) {
                AccessibleObject fld = accessibleObjectArray2[n];
                af.add(fld);
                ++n;
            }
            AccessibleObject.setAccessible(accessibleObjectArray, true);
        } while ((cls = cls.getSuperclass()) != null);
        for (Field field : af) {
            Element elt;
            OmElement omelt;
            Object val;
            String name = field.getName();
            int modif = field.getModifiers();
            if (name.startsWith("p_") || name.startsWith("r_")) continue;
            if (name.startsWith("s_")) {
                val = Reflector.getFieldValue(field, obj);
                if (val == null) {
                    E.warning("found special field " + name + " but value is null");
                    continue;
                }
                int hcode = val.hashCode();
                if (ctxt.acceptsReferents()) {
                    ctxt.addReferent("" + hcode, val);
                    OmElement elt2 = new OmElement();
                    elt2.setName(name);
                    elt2.addAttribute("archive-hash", "" + hcode);
                    elements.add(elt2);
                    continue;
                }
                E.warning(" - (Reflector) special object not saved " + name + " " + val);
                continue;
            }
            if (Modifier.isFinal(modif) && Modifier.isStatic(modif) || (val = Reflector.getFieldValue(field, obj)) == null) continue;
            if (val instanceof Map) {
                E.error("raw map in reflector as child of " + obj);
                E.error(" - ignoring " + val);
                continue;
            }
            if (val instanceof Stateless) continue;
            if (val instanceof String) {
                attributes.add(new OmAttribute(name, (String)val));
                continue;
            }
            if (!ctxt.recurseAll() && !(val instanceof int[][]) && !(val instanceof double[][]) || (omelt = (OmElement)(elt = elementizer.makeElement(val))) == null) continue;
            omelt.setName(name);
            elements.add(omelt);
        }
        OmElement omElement = new OmElement(attributes, elements);
        omElement.setName(eltname);
        return omElement;
    }

    public static Object getFieldValue(Field field, Object obj) {
        Object val = null;
        try {
            val = field.get(obj);
        }
        catch (Exception ex) {
            E.error(" getting field " + field.getName() + " on " + obj.getClass().getName() + " " + ex);
            val = "ERROR";
        }
        return SerialUtil.stringifyObject(val);
    }
}

