/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.mesh;

import org.catacomb.numeric.mesh.MeshPoint;

public class DifMeshPoint
implements MeshPoint {
    double xpos;
    double ypos;
    double zpos;
    double radius;
    int idIndex = -1;
    int nnbr;
    DifMeshPoint[] nbrs = new DifMeshPoint[4];
    int iwork;

    public DifMeshPoint() {
    }

    public DifMeshPoint(double x, double y, double z, double r, int idx) {
        this();
        this.xpos = x;
        this.ypos = y;
        this.zpos = z;
        this.radius = r;
        this.idIndex = idx;
    }

    public int getNeighborCount() {
        return this.nnbr;
    }

    public MeshPoint[] getNeighbors() {
        return this.nbrs;
    }

    public void addNeighbor(MeshPoint nnn) {
        this.nbrs[this.nnbr] = (DifMeshPoint)nnn;
        ++this.nnbr;
    }

    public void replaceNeighbor(MeshPoint oldNode, MeshPoint newNode) {
        int i = 0;
        while (i < this.nnbr) {
            if (this.nbrs[i] == oldNode) {
                this.nbrs[i] = (DifMeshPoint)newNode;
            }
            ++i;
        }
    }

    public void disconnect() {
        this.nnbr = 0;
    }

    public void setWork(int i) {
        this.iwork = i;
    }

    public int getWork() {
        return this.iwork;
    }

    public double getX() {
        return this.xpos;
    }

    public double getY() {
        return this.ypos;
    }

    public double getZ() {
        return this.zpos;
    }

    public double getR() {
        return this.radius;
    }

    public int getIDIndex() {
        return this.idIndex;
    }

    public void setX(double x) {
        this.xpos = x;
    }

    public void setY(double y) {
        this.ypos = y;
    }

    public void setZ(double z) {
        this.zpos = z;
    }

    public void setR(double r) {
        this.radius = r;
    }

    public MeshPoint newPoint() {
        return new DifMeshPoint();
    }

    public MeshPoint[] newPointArray(int n) {
        return new DifMeshPoint[n];
    }
}

