/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.mesh;

import java.util.HashMap;
import org.catacomb.interlish.structure.Mesh;
import org.catacomb.interlish.structure.MeshBuilder;
import org.catacomb.numeric.mesh.DifMesh;
import org.catacomb.numeric.mesh.DifMeshPoint;
import org.catacomb.numeric.mesh.MeshPoint;

public class DifMeshBuilder
implements MeshBuilder {
    DifMesh dmesh;
    int npoint;
    MeshPoint[] points;
    HashMap<Object, DifMeshPoint> peerHM;

    public void startMesh() {
        this.peerHM = new HashMap();
        this.points = new DifMeshPoint[100];
        this.npoint = 0;
    }

    public Object newPoint(double x, double y, double z, double r, int idx, Object peer) {
        DifMeshPoint dmp = new DifMeshPoint(x, y, z, r, idx);
        this.peerHM.put(peer, dmp);
        this.addPoint(dmp);
        return dmp;
    }

    public void addPoint(DifMeshPoint pt) {
        if (this.npoint >= this.points.length) {
            MeshPoint[] dmpa = new MeshPoint[3 * this.npoint / 2];
            int i = 0;
            while (i < this.npoint) {
                dmpa[i] = this.points[i];
                ++i;
            }
            this.points = dmpa;
        }
        this.points[this.npoint++] = pt;
    }

    private DifMeshPoint getPoint(Object obj) {
        return this.peerHM.get(obj);
    }

    public void connectToPeer(Object mp1, Object o2) {
        DifMeshPoint dmpa = (DifMeshPoint)mp1;
        DifMeshPoint dmpb = this.getPoint(o2);
        dmpa.addNeighbor(dmpb);
        dmpb.addNeighbor(dmpa);
    }

    public Mesh getMesh() {
        DifMesh dm = new DifMesh();
        this.trimPointArray();
        dm.setPoints(this.points);
        return dm;
    }

    public void trimPointArray() {
        if (this.points.length != this.npoint) {
            MeshPoint[] dmpa = new MeshPoint[this.npoint];
            int i = 0;
            while (i < this.npoint) {
                dmpa[i] = this.points[i];
                ++i;
            }
            this.points = dmpa;
        }
    }
}

