/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.difnet.model;

import org.catacomb.numeric.difnet.StructureLink;
import org.catacomb.numeric.difnet.StructureNode;
import org.catacomb.numeric.difnet.model.BasicStateLink;
import org.catacomb.numeric.difnet.model.BasicStateNode;
import org.catacomb.numeric.difnet.model.BasicStructureNode;
import org.catacomb.numeric.geom.Carrot;

public class BasicStructureLink
implements StructureLink {
    BasicStructureNode nodeA;
    BasicStructureNode nodeB;
    boolean flip;
    double area;
    double capacitance;
    double conductance;
    double activeArea;

    public BasicStructureLink() {
    }

    public BasicStructureLink(BasicStructureNode bsna, BasicStructureNode bsnb) {
        this.nodeA = bsna;
        this.nodeB = bsnb;
    }

    public void setFlip() {
        this.flip = true;
    }

    public void applyAreaConductance(double g) {
        this.conductance = this.activeArea * g;
    }

    public void applyAreaCapacitance(double c) {
        this.capacitance = this.activeArea * c;
    }

    public void applyAxialConductance(double g) {
        double cond = Carrot.conductance(this.nodeA.getX(), this.nodeA.getY(), this.nodeA.getZ(), this.nodeA.getRadius(), this.nodeB.getX(), this.nodeB.getY(), this.nodeB.getZ(), this.nodeB.getRadius());
        this.conductance = g * cond;
    }

    public BasicStateLink newState(BasicStateNode sna, BasicStateNode snb) {
        return new BasicStateLink(this, sna, snb);
    }

    public void setNodeA(StructureNode sn) {
        this.nodeA = (BasicStructureNode)sn;
    }

    public StructureNode getNodeA() {
        return this.nodeA;
    }

    public void setNodeB(StructureNode sn) {
        this.nodeB = (BasicStructureNode)sn;
    }

    public StructureNode getNodeB() {
        return this.nodeB;
    }

    public void calculateArea() {
        double farea = Carrot.area(this.nodeA.getX(), this.nodeA.getY(), this.nodeA.getZ(), this.nodeA.getRadius(), this.nodeB.getX(), this.nodeB.getY(), this.nodeB.getZ(), this.nodeB.getRadius());
        double har = farea / 2.0;
        this.nodeA.incrementArea(har);
        this.nodeB.incrementArea(har);
    }

    public double getActiveArea() {
        return this.activeArea;
    }

    public void setActiveArea(double activeArea) {
        this.activeArea = activeArea;
    }

    public double getCapacitance() {
        return this.capacitance;
    }

    public double getConductance() {
        return this.conductance;
    }
}

