/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.difnet.model;

import org.catacomb.numeric.difnet.NetState;
import org.catacomb.numeric.difnet.NetStructure;
import org.catacomb.numeric.difnet.StructureLink;
import org.catacomb.numeric.difnet.StructureNode;
import org.catacomb.numeric.difnet.model.BasicNetState;
import org.catacomb.numeric.difnet.model.BasicStateLink;
import org.catacomb.numeric.difnet.model.BasicStateNode;
import org.catacomb.numeric.difnet.model.BasicStructureLink;
import org.catacomb.numeric.difnet.model.BasicStructureNode;
import org.catacomb.report.E;

public class BasicNetStructure
implements NetStructure {
    BasicStructureNode environmentNode;
    int nEnvironmentLink;
    public BasicStructureNode[] nodes;
    public BasicStructureLink[] links;

    public StructureNode[] getNodes() {
        return this.nodes;
    }

    public StructureLink[] getLinks() {
        return this.links;
    }

    public void setNodes(BasicStructureNode[] anp) {
        this.nodes = anp;
    }

    public void setLinks(BasicStructureLink[] alp) {
        this.links = alp;
    }

    public void setSurfaceCapacitance(double csurf) {
        if (this.environmentNode != null) {
            E.error(" - creatine new env node when already have one BasicNetStructure");
        }
        int nn = this.nodes.length;
        int nl = this.links.length;
        BasicStructureNode[] nna = new BasicStructureNode[nn + 1];
        BasicStructureLink[] lka = new BasicStructureLink[nl + nn];
        this.environmentNode = new BasicStructureNode();
        this.environmentNode.setFixed(true);
        this.nEnvironmentLink = nn;
        int i = 0;
        while (i < nn) {
            nna[i] = this.nodes[i];
            ++i;
        }
        nna[nn] = this.environmentNode;
        i = 0;
        while (i < nn) {
            nna[i].setArea(0.0);
            ++i;
        }
        i = 0;
        while (i < nl) {
            this.links[i].calculateArea();
            ++i;
        }
        i = 0;
        while (i < nn) {
            BasicStructureLink bsl = new BasicStructureLink(nna[i], this.environmentNode);
            double acta = nna[i].getArea();
            bsl.setActiveArea(acta);
            bsl.applyAreaCapacitance(csurf);
            lka[i] = bsl;
            ++i;
        }
        i = 0;
        while (i < nl) {
            lka[nn + i] = this.links[i];
            ++i;
        }
        this.nodes = nna;
        this.links = lka;
    }

    public void setEnvironmentValue(double d) {
        if (this.environmentNode == null) {
            this.setSurfaceCapacitance(0.0);
        }
        this.environmentNode.setFixedValue(d);
    }

    public void setInitialValue(double d) {
        int i = 0;
        while (i < this.nodes.length) {
            this.nodes[i].setInitialValue(d);
            ++i;
        }
    }

    public void setSurfaceConductance(double gsurf) {
        if (this.environmentNode == null) {
            this.setSurfaceCapacitance(0.0);
        }
        int i = 0;
        while (i < this.nEnvironmentLink) {
            this.links[i].applyAreaConductance(gsurf);
            ++i;
        }
    }

    public void setAxialConductance(double d) {
        int i = this.nEnvironmentLink;
        while (i < this.links.length) {
            this.links[i].applyAxialConductance(d);
            ++i;
        }
    }

    public NetState newState() {
        int nn = this.nodes.length;
        int nl = this.links.length;
        BasicStateNode[] stateNodes = new BasicStateNode[nn];
        BasicStateLink[] stateLinks = new BasicStateLink[nl];
        int i = 0;
        while (i < nn) {
            this.nodes[i].setWork(i);
            ++i;
        }
        i = 0;
        while (i < nn) {
            stateNodes[i] = this.nodes[i].newState();
            ++i;
        }
        i = 0;
        while (i < nl) {
            BasicStructureLink lkp = this.links[i];
            stateLinks[i] = lkp.newState(stateNodes[lkp.getNodeA().getWork()], stateNodes[lkp.getNodeB().getWork()]);
            ++i;
        }
        return new BasicNetState(this, stateNodes, stateLinks);
    }
}

