/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.difnet.model;

import java.util.ArrayList;
import org.catacomb.numeric.difnet.NetState;
import org.catacomb.numeric.difnet.model.PointRecorder;
import org.catacomb.report.E;

public class BasicNetRecorder {
    ArrayList<PointRecorder> pointRecorders = new ArrayList();
    int nrec;
    String[] recLabels;
    int[] recIndices;

    public void addPotentialRecorder(String id, String tag, String probePort) {
        this.pointRecorders.add(new PointRecorder(id, tag, probePort));
    }

    public void resolve(int[] remeshMap) {
        this.nrec = this.pointRecorders.size();
        this.recLabels = new String[this.nrec];
        this.recIndices = new int[this.nrec];
        int iel = 0;
        for (PointRecorder pr : this.pointRecorders) {
            this.recLabels[iel] = pr.getID();
            String sp = pr.getPort();
            if (sp == null || sp.length() == 0) {
                E.warning("null port on probe " + pr);
            } else {
                try {
                    int ipt = Integer.parseInt(sp);
                    if (ipt < 0) {
                        E.warning("negative port id in " + pr);
                    } else {
                        this.recIndices[iel] = remeshMap[ipt];
                    }
                }
                catch (Exception ex) {
                    E.error("must have integer port ids, not " + sp);
                }
            }
            ++iel;
        }
    }

    public String[] getRecorderLabels() {
        return this.recLabels;
    }

    public double[] getValues(NetState netState) {
        double[] ret = new double[this.nrec];
        int i = 0;
        while (i < this.nrec) {
            ret[i] = netState.getValueAt(this.recIndices[i]);
            ++i;
        }
        return ret;
    }
}

