/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.util.ArrayList;
import org.catacomb.interlish.structure.Parent;
import org.catacomb.numeric.data.AnimSlice;
import org.catacomb.numeric.data.BlockStack;
import org.catacomb.numeric.data.DSlice;
import org.catacomb.numeric.data.DVector;
import org.catacomb.numeric.data.NumDataItem;
import org.catacomb.numeric.data.NumDataStore;
import org.catacomb.numeric.data.NumVector;
import org.catacomb.numeric.data.NumVectorSet;
import org.catacomb.numeric.data.StackSlice;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NDSAccessor {
    NumDataStore store;

    public NDSAccessor(NumDataStore ndstore) {
        this.store = ndstore;
    }

    public NumDataItem getNumDataItem(String s) {
        NumDataItem numv = null;
        ArrayList<Object> op = this.getObjectPath(s);
        if (op != null && op.size() > 0) {
            Object obj = op.get(op.size() - 1);
            if (obj instanceof NumDataItem) {
                numv = (NumDataItem)obj;
            } else {
                E.warning("wrong type " + obj + " when seeking " + s + " expecting NDI but got " + obj.getClass().getName());
            }
        }
        return numv;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArrayList<Object> getObjectPath(String s) {
        ArrayList<Object> ret = new ArrayList<Object>();
        String[] sa = s.split("/");
        Object osf = this.store;
        ret.add(osf);
        int ioff = 0;
        if (sa[0].equals(this.store.toString())) {
            ioff = 1;
        }
        int i = ioff;
        while (i < sa.length) {
            if (osf instanceof Parent) {
                Parent par = (Parent)osf;
                if (!par.hasChild(sa[i])) {
                    E.possibleError(" no child \"" + sa[i] + "\" in parent " + "\"" + par + "\"");
                    return null;
                }
                osf = par.getChild(sa[i]);
                ret.add(osf);
            } else {
                E.error("need a parent object, not " + osf);
            }
            ++i;
        }
        return ret;
    }

    public ArrayList<NumDataItem> getOrdinates(NumVector numV) {
        ArrayList<NumDataItem> ret = new ArrayList<NumDataItem>();
        if (numV instanceof DSlice) {
            BlockStack bs = (BlockStack)((DSlice)numV).getParent();
            this.addStackSlices(bs, ret, numV);
        } else if (numV instanceof DVector) {
            int np = ((DVector)numV).getNPoint();
            for (DVector dv : this.store.getDVectors()) {
                if (dv.getNPoint() != np) continue;
                ret.add(dv);
            }
            for (BlockStack bs : this.store.getBlockStacks()) {
                if (bs.getSize() == np) {
                    this.addStackSlices(bs, ret, null);
                    continue;
                }
                if (np == 1 || bs.getSize() == 1) continue;
                E.info("not adding a possible ordinate since it is a different size (" + np + " compared with " + bs.getSize() + ") " + bs.getName());
            }
        } else {
            E.missing();
        }
        return ret;
    }

    private void addStackSlices(BlockStack bs, ArrayList<NumDataItem> ret, Object excl) {
        for (StackSlice obj : bs.getSlices()) {
            if (obj == excl) continue;
            if (obj instanceof NumVector) {
                ret.add((NumDataItem)((Object)obj));
                continue;
            }
            if (obj instanceof NumVectorSet) {
                ret.add((NumDataItem)((Object)obj));
                continue;
            }
            if (obj instanceof AnimSlice) continue;
            E.info("ignoring " + obj);
        }
    }

    public NumDataItem getSibling(NumVector numV, String snm) {
        NumDataItem ret = null;
        ArrayList<NumDataItem> ndis = this.getOrdinates(numV);
        for (NumDataItem ndi : ndis) {
            if (!snm.equals(ndi.getName())) continue;
            ret = ndi;
            break;
        }
        return ret;
    }
}

