/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.util.HashMap;
import org.catacomb.numeric.data.DataItem;
import org.catacomb.numeric.data.DataSetArray;
import org.catacomb.numeric.data.FloatScalar;
import org.catacomb.numeric.data.FloatVector;
import org.catacomb.numeric.data.NumDataSet;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSlice {
    String item = null;
    String func = null;
    String slice = null;
    DataSlice subslice;
    DataSlice[] subsliceArray;
    double scalarValue;
    double[] vectorValue;
    NumDataSet objectValue;
    DataSetArray arrayValue;
    int resultType;
    static final int SCALAR = 1;
    static final int VECTOR = 2;
    static final int OBJECT = 3;
    static final int ARRAY = 4;

    public DataSlice(String pe) {
        if (pe != null) {
            this.extractFrom(pe);
        }
    }

    private DataSlice copy() {
        DataSlice ret = new DataSlice(null);
        ret.item = this.item;
        ret.func = this.func;
        ret.slice = this.slice;
        if (this.subslice != null) {
            ret.subslice = this.subslice.copy();
        }
        return ret;
    }

    private void extractFrom(String pe) {
        int iosb = pe.indexOf("[");
        int icsb = pe.lastIndexOf("]");
        if (iosb > 0 && icsb > iosb) {
            this.slice = pe.substring(iosb + 1, icsb);
            String npe = pe.substring(0, iosb);
            if (pe.length() > icsb) {
                npe = String.valueOf(npe) + pe.substring(icsb + 1, pe.length());
            }
            pe = npe;
        }
        int iorb = pe.indexOf("(");
        int icrb = pe.lastIndexOf(")");
        if (iorb > 0 && icrb > iorb) {
            this.func = pe.substring(iorb + 1, icrb);
            pe = pe.substring(0, iorb);
        }
        this.item = pe;
    }

    public void setSubslice(DataSlice dsl) {
        this.subslice = dsl;
    }

    public void resolve(HashMap<String, NumDataSet> hmap) {
        NumDataSet target = hmap.get(this.item);
        if (target == null) {
            E.error("data set (type " + this.resultType + ") hash map has no element " + this.item);
            for (String s : hmap.keySet()) {
                E.info("hmap val " + hmap.get(s));
            }
        } else {
            this.applyResolve(target);
        }
    }

    public void mark(HashMap<String, NumDataSet> hm) {
        NumDataSet dset = hm.get(this.item);
        this.applyMark(dset);
    }

    public void mark(NumDataSet dset) {
        dset.mark();
        DataItem target = dset.get(this.item);
        if (target == null) {
            E.error("data slice result is null on  slice=" + this.slice + " func=" + this.func + " item=" + this.item + " dataSet=" + dset);
        } else {
            this.applyMark(target);
        }
    }

    private void applyMark(DataItem dit) {
        dit.mark();
        if (dit instanceof DataSetArray) {
            if (this.slice != null && !this.slice.equals("-1")) {
                dit = ((DataSetArray)dit).slice(this.slice);
            }
            if (this.subslice != null) {
                NumDataSet[] dsa = ((DataSetArray)dit).getDataSets();
                int i = 0;
                while (i < dsa.length) {
                    dsa[i].mark();
                    this.subslice.mark(dsa[i]);
                    ++i;
                }
            }
        } else if (dit instanceof NumDataSet && this.subslice != null) {
            this.subslice.mark((NumDataSet)dit);
        }
    }

    public void resolve(NumDataSet dset) {
        DataItem target = dset.get(this.item);
        if (target == null) {
            E.error("data slice result is null on  slice=" + this.slice + " func=" + this.func + " item=" + this.item + " dataSet=" + dset);
        } else {
            this.applyResolve(target);
        }
    }

    private void applyResolve(Object target) {
        if (target instanceof FloatScalar) {
            this.scalarValue = ((FloatScalar)target).getValue();
            if (this.func != null) {
                this.scalarValue = this.applyFuncToScalar(this.scalarValue, this.func);
            }
            this.resultType = 1;
        } else if (target instanceof FloatVector) {
            this.vectorValue = ((FloatVector)target).getValue();
            if (this.slice != null) {
                this.vectorValue = this.applySliceToVector(this.vectorValue, this.slice);
            }
            if (this.func != null) {
                this.vectorValue = this.applyFuncToVector(this.vectorValue, this.func);
            }
            this.resultType = 2;
        } else if (target instanceof NumDataSet) {
            this.objectValue = (NumDataSet)target;
            this.resultType = 3;
        } else if (target instanceof DataSetArray) {
            this.arrayValue = (DataSetArray)target;
            this.resultType = 4;
            if (this.slice != null) {
                this.arrayValue = this.arrayValue.slice(this.slice);
                if (this.arrayValue.length() == 1) {
                    this.resultType = 3;
                    this.objectValue = this.arrayValue.firstElement();
                }
            }
        } else {
            E.error("Data Slice - unknown target type " + target);
        }
        if (this.subslice != null) {
            if (this.resultType == 3) {
                this.subslice.resolve(this.objectValue);
            } else if (this.resultType == 4) {
                NumDataSet[] dsa = this.arrayValue.getDataSets();
                this.subsliceArray = new DataSlice[dsa.length];
                int i = 0;
                while (i < dsa.length) {
                    this.subsliceArray[i] = this.subslice.copy();
                    this.subsliceArray[i].resolve(dsa[i]);
                    ++i;
                }
                this.subslice = null;
            }
        }
    }

    public double getScalar() {
        double ret = 0.0;
        if (this.subslice != null) {
            ret = this.subslice.getScalar();
        } else if (this.resultType == 1) {
            ret = this.scalarValue;
        } else if (this.resultType == 2 && this.vectorValue.length == 1) {
            ret = this.vectorValue[0];
        } else {
            E.error("requested scalar from non-scalar data slice " + this.resultType);
        }
        return ret;
    }

    public double[] getVector() {
        double[] ret = null;
        if (this.subslice != null) {
            ret = this.subslice.getVector();
        } else if (this.subsliceArray != null) {
            int ns = this.subsliceArray.length;
            ret = new double[ns];
            int i = 0;
            while (i < ns) {
                ret[i] = this.subsliceArray[i].getScalar();
                ++i;
            }
        } else if (this.resultType == 2) {
            ret = this.vectorValue;
        } else if (this.resultType == 3 && this.subslice != null) {
            ret = this.subslice.getVector();
        } else {
            E.debugError("requested vector from non-scalar data slice " + this.resultType + " " + this.item);
        }
        return ret;
    }

    public int[] getIntVector() {
        int[] ret = null;
        if (this.subslice != null) {
            ret = this.subslice.getIntVector();
        } else if (this.subsliceArray != null) {
            int ns = this.subsliceArray.length;
            ret = new int[ns];
            int i = 0;
            while (i < ns) {
                ret[i] = i;
                ++i;
            }
        } else if (this.resultType == 4) {
            int ns = this.arrayValue.length();
            ret = new int[ns];
            int i = 0;
            while (i < ns) {
                ret[i] = i;
                ++i;
            }
        } else {
            E.error("cant get int vector from " + this + " restype=" + this.resultType);
        }
        return ret;
    }

    public void markVector() {
    }

    public void markIntVector() {
    }

    public void markScalar() {
    }

    private double[] applyFuncToVector(double[] da, String lfunc) {
        double[] ret = new double[da.length];
        if (lfunc.equals("log10")) {
            double mlten = Math.log(10.0);
            int i = 0;
            while (i < da.length) {
                ret[i] = Math.log(da[i]) / mlten;
                ++i;
            }
        } else {
            E.error("Data slice unknown function " + lfunc);
        }
        return ret;
    }

    private double applyFuncToScalar(double d, String lfunc) {
        double ret = 0.0;
        if (lfunc.equals("log10")) {
            double mlten = Math.log(10.0);
            ret = Math.log(d) / mlten;
        } else {
            E.error("Data slice unknown function " + lfunc);
        }
        return ret;
    }

    private double[] applySliceToVector(double[] da, String lslice) {
        double[] ret = new double[1];
        int ival = Integer.parseInt(lslice);
        ret[0] = da[ival];
        return ret;
    }
}

