/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.util.HashMap;
import org.catacomb.interlish.reflect.Narrower;
import org.catacomb.numeric.data.DataSlice;
import org.catacomb.numeric.data.NumDataSet;

public class DataExtractor {
    HashMap<String, NumDataSet> sources = new HashMap();

    public NumDataSet getDataSet(String s) {
        return this.sources.get(s);
    }

    public void addDataSet(NumDataSet dset) {
        this.sources.put(dset.getName(), dset);
    }

    public double getScalar(String path) {
        DataSlice ds = this.get(path);
        return ds.getScalar();
    }

    public double[] getVector(String path) {
        double[] ret = null;
        if (path.startsWith("{")) {
            ret = this.getExplicitVector(path);
        } else {
            DataSlice ds = this.get(path);
            ret = ds.getVector();
        }
        return ret;
    }

    public int[] getIntVector(String path) {
        DataSlice ds = this.get(path);
        int[] ret = ds.getIntVector();
        return ret;
    }

    public void mark(String path) {
        DataSlice dsret = this.constructSlice(path);
        dsret.mark(this.sources);
    }

    private DataSlice get(String path) {
        DataSlice dsret = this.constructSlice(path);
        dsret.resolve(this.sources);
        return dsret;
    }

    private DataSlice constructSlice(String path) {
        DataSlice dsret;
        String[] bits = path.split("\\.");
        DataSlice dscur = dsret = new DataSlice(bits[0]);
        int i = 1;
        while (i < bits.length) {
            DataSlice dssub = new DataSlice(bits[i]);
            dscur.setSubslice(dssub);
            dscur = dssub;
            ++i;
        }
        return dsret;
    }

    public double[] getExplicitVector(String stxt) {
        double[] ret = Narrower.readDoubleArray(stxt);
        return ret;
    }
}

