/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.catacomb.datalish.RunDataBlock;
import org.catacomb.datalish.SpriteStore;
import org.catacomb.interlish.content.BasicTouchTime;
import org.catacomb.interlish.structure.Named;
import org.catacomb.interlish.structure.Parent;
import org.catacomb.interlish.structure.TreeChangeReporter;
import org.catacomb.interlish.structure.TreeNode;
import org.catacomb.numeric.data.AnimSlice;
import org.catacomb.numeric.data.DDSlice;
import org.catacomb.numeric.data.DSlice;
import org.catacomb.numeric.data.MultiSprites;
import org.catacomb.numeric.data.NumDataStore;
import org.catacomb.numeric.data.NumVector;
import org.catacomb.numeric.data.Quantity;
import org.catacomb.numeric.data.QuantityDA;
import org.catacomb.numeric.data.SpriteState;
import org.catacomb.numeric.data.StackSlice;
import org.catacomb.numeric.data.XYVectorScene;
import org.catacomb.numeric.data.XYVectorSprite;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockStack
implements Named,
TreeNode,
Parent {
    ArrayList<RunDataBlock> items;
    String name;
    ArrayList<StackSlice> slices;
    HashMap<String, StackSlice> sliceHM;
    BasicTouchTime changeTime;
    boolean doneInit;
    TreeChangeReporter tcReporter;
    NumDataStore store;

    public BlockStack(NumDataStore p, String snm) {
        this.name = snm;
        this.store = p;
        this.doneInit = false;
        this.items = new ArrayList();
        this.slices = new ArrayList();
        this.sliceHM = new HashMap();
        this.changeTime = new BasicTouchTime();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Object getParent() {
        return this.store;
    }

    public BasicTouchTime getChangeTime() {
        return this.changeTime;
    }

    public void addToStack(RunDataBlock str) {
        if (!this.doneInit) {
            this.initSlices(str);
            this.doneInit = true;
        }
        this.items.add(str);
        this.changeTime.now();
        this.reportValueChange();
    }

    public void clear() {
        this.items.clear();
        for (StackSlice ss : this.sliceHM.values()) {
            ss.clear();
        }
        this.changeTime.now();
    }

    private Field getField(Object proto, String fnm) {
        Field ret = null;
        Field[] fieldArray = proto.getClass().getFields();
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field f = fieldArray[n];
            if (f.getName().equals(fnm)) {
                ret = f;
                break;
            }
            ++n;
        }
        return ret;
    }

    private void initSlices(RunDataBlock proto) {
        HashMap<String, Object> staticsHM = new HashMap<String, Object>();
        Field[] fieldArray = proto.getClass().getFields();
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Annotation spr;
            Field f = fieldArray[n];
            String fnm = f.getName();
            String unit = "";
            String title = f.getName();
            String[] arrayEltNames = null;
            if (f.getType().isArray() && f.getType().getComponentType().equals(String.class) || f.getType().equals(XYVectorSprite.class) || f.getType().equals(XYVectorScene.class)) {
                try {
                    Object obj = f.get(proto);
                    if (obj != null) {
                        staticsHM.put(f.getName(), obj);
                    }
                }
                catch (Exception obj) {}
            } else if (f.isAnnotationPresent(Quantity.class)) {
                Quantity q = f.getAnnotation(Quantity.class);
                unit = q.unit();
                title = q.title();
            } else if (f.isAnnotationPresent(QuantityDA.class)) {
                QuantityDA qda = f.getAnnotation(QuantityDA.class);
                unit = qda.unit();
                title = qda.title();
                String nameSet = qda.nameSet();
                if (nameSet != null && nameSet.length() > 0) {
                    if (staticsHM.containsKey(qda.nameSet())) {
                        arrayEltNames = (String[])staticsHM.get(nameSet);
                    } else {
                        E.warning("ref to names set " + nameSet + " - not found");
                    }
                }
            } else if (f.isAnnotationPresent(SpriteState.class)) {
                spr = f.getAnnotation(SpriteState.class);
                title = spr.title();
            } else if (f.isAnnotationPresent(MultiSprites.class)) {
                spr = f.getAnnotation(MultiSprites.class);
                title = spr.title();
            } else {
                E.warning("all fields in blocks should be annotated with a Quantity  annotation: " + f.getName() + " in " + proto);
            }
            if (f.isAnnotationPresent(MultiSprites.class)) {
                spr = f.getAnnotation(MultiSprites.class);
                title = spr.title();
                SpriteStore ss = this.store.getSpriteStore();
                AnimSlice ans = new AnimSlice(this, fnm, f, title, ss);
                this.sliceHM.put(fnm, ans);
                this.slices.add(ans);
            } else if (f.getType().equals(Double.TYPE)) {
                DSlice sds = new DSlice(this, fnm, f, unit, title);
                this.sliceHM.put(fnm, sds);
                this.slices.add(sds);
            } else if (f.getType().isArray()) {
                Class<?> ctyp = f.getType().getComponentType();
                if (!ctyp.equals(String.class)) {
                    if (ctyp.equals(Double.TYPE)) {
                        DDSlice sdas = new DDSlice(this, fnm, f, unit, title, arrayEltNames);
                        this.sliceHM.put(fnm, sdas);
                        this.slices.add(sdas);
                    } else if (ctyp.equals(Integer.TYPE)) {
                        E.shortWarning(" missing code for int[] arrays");
                    } else if (ctyp.isArray()) {
                        E.shortWarning("missing code for array of arrays");
                    } else {
                        E.error("cant handle array of type " + ctyp);
                    }
                }
            } else if (!f.getType().equals(XYVectorScene.class)) {
                E.error("unrecognized class " + f + " " + f.getType());
            }
            ++n;
        }
        this.reportNewFields();
    }

    public int getSize() {
        return this.items.size();
    }

    public RunDataBlock getBlock(int i) {
        return this.items.get(i);
    }

    private void reportNewFields() {
        this.tcReporter.nodeAddedUnder(this, null);
    }

    private void reportValueChange() {
    }

    public void setTreeChangeReporter(TreeChangeReporter tcr) {
        this.tcReporter = tcr;
    }

    @Override
    public int getChildCount() {
        return this.slices.size();
    }

    @Override
    public Object getChild(int index) {
        return this.slices.get(index);
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.slices.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean hasChild(String s) {
        return this.sliceHM.containsKey(s);
    }

    @Override
    public Object getChild(String s) {
        return this.sliceHM.get(s);
    }

    public ArrayList<StackSlice> getSlices() {
        return this.slices;
    }

    public NumVector getFirstArraySlice() {
        NumVector ret = null;
        for (StackSlice ss : this.slices) {
            if (!(ss instanceof NumVector)) continue;
            ret = (NumVector)((Object)ss);
            break;
        }
        return ret;
    }

    public Collection<? extends AnimSlice> getMovies() {
        ArrayList<AnimSlice> msls = new ArrayList<AnimSlice>();
        for (StackSlice sl : this.slices) {
            if (!(sl instanceof AnimSlice)) continue;
            msls.add((AnimSlice)sl);
        }
        return msls;
    }
}

