/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.content;

import java.io.File;
import org.catacomb.be.FileSourcable;
import org.catacomb.interlish.content.BasicTouchTime;
import org.catacomb.interlish.structure.IDd;
import org.catacomb.interlish.structure.Labelled;
import org.catacomb.report.E;

public class DocumentedComponent
implements IDd,
Labelled,
FileSourcable {
    public String id;
    public String label;
    public String tag;
    public String info;
    public File sourceFile;
    String shortID;
    BasicTouchTime touchTime = new BasicTouchTime();
    boolean justLoaded = true;

    public DocumentedComponent() {
        this.id = "id";
        this.label = "...";
    }

    public DocumentedComponent(String s) {
        this.id = s;
        this.label = s;
    }

    public boolean justLoaded() {
        boolean ret = this.justLoaded;
        this.justLoaded = false;
        return ret;
    }

    public BasicTouchTime getTouchTime() {
        return this.touchTime;
    }

    public void setTag(String s) {
        this.tag = s;
    }

    public void setInfo(String s) {
        this.info = s;
    }

    public String getTag() {
        return this.tag;
    }

    public String getInfo() {
        return this.info;
    }

    public void setID(String s) {
        this.id = s.trim();
        if (this.label == null) {
            this.label = this.id;
        }
        this.shortID = null;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public boolean hasTag() {
        return this.tag != null && this.tag.length() > 0;
    }

    public boolean hasInfo() {
        return this.info != null && this.info.length() > 0;
    }

    public String getNonTrivialLabel() {
        String ret = this.label;
        if (ret == null || ret.length() == 0 || ret.equals("...")) {
            ret = this.id;
        }
        return ret;
    }

    public String getLabel() {
        return this.label;
    }

    public String getID() {
        return this.id.trim();
    }

    public String getFullID() {
        String ret = this.getID();
        if (ret.indexOf(".") < 0) {
            E.warning("probably need to qualify " + ret);
        }
        return ret;
    }

    public String getShortID() {
        if (this.shortID == null) {
            this.shortID = this.id.substring(this.id.lastIndexOf(".") + 1, this.id.length());
        }
        return this.shortID;
    }

    public String getTypeID() {
        String s = this.getClass().getName();
        s = s.substring(s.lastIndexOf(".") + 1, s.length());
        return s;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File f) {
        this.sourceFile = f;
    }
}

