/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.catacomb.graph.gui.BaseCanvas;
import org.catacomb.graph.gui.RangeListener;
import org.catacomb.report.E;

public class YAxisCanvas
extends BaseCanvas
implements RangeListener {
    static final long serialVersionUID = 1001L;
    double ylow;
    double yhigh;
    int ntick = 5;
    String labY;
    static final int[] intervals = new int[]{1, 2, 5};
    AffineTransform upTransform = new AffineTransform();
    AffineTransform normalTransform;

    public YAxisCanvas(int w, int h) {
        super(w, h);
        this.upTransform.setToRotation(-1.5707963267948966);
        this.normalTransform = new AffineTransform();
    }

    public void setLabel(String s) {
        this.labY = s;
    }

    public void rangeChanged(int mode, double[] xyxylims) {
        if (mode == 1 || mode == 3) {
            this.ylow = xyxylims[1];
            this.yhigh = xyxylims[3];
            this.repaint();
        }
    }

    public void paint2D(Graphics2D g) {
        this.drawAxis(g);
    }

    public final void drawAxis(Graphics2D g) {
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.getNormalForeground());
        int width = this.getWidth();
        int height = this.getHeight();
        double yran = Math.abs(this.yhigh - this.ylow);
        double dy = 1.5 * yran / (double)this.ntick;
        double log = Math.log(dy) / Math.log(10.0);
        double powten = (int)Math.floor(log);
        int iiind = (int)(2.999 * (log - powten));
        if (iiind < 0 || iiind >= 3) {
            E.error("error gdc, 650: " + log + " " + powten + " " + iiind);
            iiind = 2;
        }
        int ii = intervals[iiind];
        dy = Math.pow(10.0, powten) * (double)ii;
        int i0 = (int)(this.ylow / dy);
        int i1 = (int)(this.yhigh / dy);
        int i = i0;
        while (i <= i1) {
            double yy = (double)i * dy;
            String lab = "0";
            if (i != 0) {
                lab = dy >= 0.999 && dy < 10000.0 ? String.valueOf((int)yy) : String.valueOf((float)yy);
            }
            int iy = height - (int)((double)height * (yy - this.ylow) / (this.yhigh - this.ylow));
            int off = fm.stringWidth(lab);
            g.drawString(lab, width - 12 - off, iy + 4);
            g.drawLine(width - 5, iy, width, iy);
            if (this.labY != null) {
                int ilx = 18;
                int ily = height / 2 + fm.stringWidth(this.labY) / 2;
                AffineTransform at = g.getTransform();
                g.translate((double)ilx, (double)ily);
                g.rotate(-1.5707963267948966);
                g.drawString(this.labY, 0, 0);
                g.setTransform(at);
            }
            ++i;
        }
    }
}

