/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.be.Position;
import org.catacomb.datalish.Box;
import org.catacomb.graph.gui.RangeListener;
import org.catacomb.graph.gui.Size;

public final class WorldTransform {
    private double wcx;
    private double wcy;
    private int pcx;
    private int pcy;
    private int width;
    private int height;
    private int hx;
    private int hy;
    private double dpdwx;
    private double dpdwy;
    private int leftMargin = 0;
    private int rightMargin = 0;
    private int topMargin = 0;
    private int bottomMargin = 0;
    private boolean xRescalable;
    private boolean yRescalable;
    private static final int IBIG = 20000;
    private static final double SMALL = 1.0E-7;
    private final double DBIG = 1.0E9;
    private boolean recordRange;
    private double aspectRatio;
    private boolean constantAspectRatio;
    private double vxmin;
    private double vxmax;
    private double vymin;
    private double vymax;
    private boolean drawnInXRange;
    private boolean drawnInYRange;
    private boolean trialPanning = false;
    private double wcxtp;
    private double wcytp;
    int nRangeListener;
    private RangeListener[] rangeListeners;
    private Size p_pixelSize;

    public WorldTransform() {
        this.setWidth(100);
        this.setHeight(100);
        this.setXRescalable(true);
        this.setYRescalable(true);
        this.setAspectRatioFree();
        this.dpdwx = 1.0;
        this.dpdwy = 1.0;
        this.wcx = 0.0;
        this.wcy = 0.0;
        this.nRangeListener = 0;
        this.rangeListeners = new RangeListener[10];
        this.p_pixelSize = new Size(0.0, 0.0);
    }

    public void setCanvasSize(int w, int h) {
        this.setWidth(w);
        this.setHeight(h);
    }

    public final void setMargins(int l, int r, int b, int t) {
        this.leftMargin = l;
        this.rightMargin = r;
        this.topMargin = t;
        this.bottomMargin = b;
    }

    public boolean isOnCanvas(double x, double y) {
        return this.intIsOnCanvas(this.powx(x), this.powy(y));
    }

    public boolean intIsOnCanvas(int x, int y) {
        return x > -10 && x < this.width + 10 && y > -10 && y < this.height + 10;
    }

    public void addRangeListener(RangeListener rl) {
        this.rangeListeners[this.nRangeListener++] = rl;
        rl.rangeChanged(3, this.getXYXYLimits());
    }

    public void fixRanges() {
        this.notifyRangeChange(3);
    }

    public void rangeChange(int axis) {
    }

    public void notifyRangeChange() {
        this.notifyRangeChange(3);
    }

    public void notifyRangeChange(int axis) {
        double[] lims = this.getXYXYLimits();
        int i = 0;
        while (i < this.nRangeListener) {
            this.rangeListeners[i].rangeChanged(axis, lims);
            ++i;
        }
    }

    public void setPixelScalingFromTop(double d) {
        this.p_setXRange(0.0, d * (double)this.getCanvasWidth());
        this.p_setYRange(-1.0 * d * (double)this.getCanvasHeight(), 0.0);
    }

    public void setAspectRatioFree() {
        this.constantAspectRatio = false;
    }

    public void setFixedAspectRatio(double f) {
        this.setAspectRatio(f);
    }

    public void setAspectRatio(double f) {
        this.aspectRatio = f;
        this.constantAspectRatio = true;
    }

    public void setXRescalable(boolean b) {
        this.xRescalable = b;
    }

    public void setYRescalable(boolean b) {
        this.yRescalable = b;
    }

    void clearRanges() {
        this.vxmin = 1.0E9;
        this.vymin = 1.0E9;
        this.vxmax = -1.0E9;
        this.vymax = -1.0E9;
        this.drawnInXRange = false;
        this.drawnInYRange = false;
    }

    void startRangeRecording() {
        this.clearRanges();
        this.recordRange = true;
    }

    void stopRangeRecording() {
        this.recordRange = false;
    }

    public void setWidth(int w) {
        this.width = w;
        this.hx = (this.width - this.leftMargin - this.rightMargin) / 2;
        if (this.hx < 2) {
            this.hx = 2;
        }
        this.pcx = this.leftMargin + this.hx;
    }

    public void setHeight(int h) {
        this.height = h;
        this.hy = (this.height - this.topMargin - this.bottomMargin) / 2;
        if (this.hy < 2) {
            this.hy = 2;
        }
        this.pcy = this.bottomMargin + this.hy;
    }

    public int getCanvasWidth() {
        return this.width;
    }

    public int getCanvasHeight() {
        return this.height;
    }

    public double getWorldCanvasWidth() {
        return (double)this.width / this.dpdwx;
    }

    public boolean isShowing(double x, double y) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        return ix > 5 && iy > 5 && ix < this.width - 50 && iy < this.height - 5;
    }

    int[] intDeviceX(double[] wx) {
        int n = wx.length;
        int[] idev = new int[n];
        if (this.recordRange) {
            int i = 0;
            while (i < n) {
                idev[i] = this.qpowx(wx[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                idev[i] = this.powx(wx[i]);
                ++i;
            }
        }
        return idev;
    }

    int[] intDeviceY(double[] wy) {
        int n = wy.length;
        int[] idev = new int[n];
        if (this.recordRange) {
            int i = 0;
            while (i < n) {
                idev[i] = this.qpowy(wy[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                idev[i] = this.powy(wy[i]);
                ++i;
            }
        }
        return idev;
    }

    float[] floatDeviceX(double[] wx) {
        int n = wx.length;
        float[] fdev = new float[n];
        if (this.recordRange) {
            int i = 0;
            while (i < n) {
                fdev[i] = this.qpowx(wx[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                fdev[i] = this.powx(wx[i]);
                ++i;
            }
        }
        return fdev;
    }

    float[] floatDeviceY(double[] wy) {
        int n = wy.length;
        float[] fdev = new float[n];
        if (this.recordRange) {
            int i = 0;
            while (i < n) {
                fdev[i] = this.qpowy(wy[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                fdev[i] = this.powy(wy[i]);
                ++i;
            }
        }
        return fdev;
    }

    public Size getPixelSize() {
        this.p_pixelSize.set(1.0 / this.dpdwx, 1.0 / this.dpdwy);
        return this.p_pixelSize;
    }

    protected final double wopx(int x) {
        return this.wcx + (double)(x - this.pcx) / this.dpdwx;
    }

    protected final double wopy(int y) {
        return this.wcy + (double)(this.height - y - this.pcy) / this.dpdwy;
    }

    protected final int powx(double xr) {
        double f = this.dpdwx * (xr - this.wcx);
        if (f > 20000.0) {
            f = 20000.0;
        }
        if (f < -20000.0) {
            f = -20000.0;
        }
        int ii = this.pcx + (int)f;
        if (this.recordRange) {
            if (xr > this.vxmax) {
                this.vxmax = xr;
            }
            if (xr < this.vxmin) {
                this.vxmin = xr;
            }
        }
        if (ii > 0 && ii < this.width) {
            this.drawnInXRange = true;
        }
        return ii;
    }

    protected final int powy(double yr) {
        double f = this.dpdwy * (yr - this.wcy);
        if (f > 20000.0) {
            f = 20000.0;
        }
        if (f < -20000.0) {
            f = -20000.0;
        }
        int ii = this.height - (this.pcy + (int)f);
        if (this.recordRange) {
            if (yr > this.vymax) {
                this.vymax = yr;
            }
            if (yr < this.vymin) {
                this.vymin = yr;
            }
        }
        if (ii > 0 && ii < this.height) {
            this.drawnInYRange = true;
        }
        return ii;
    }

    private final int qpowx(double xr) {
        return (int)((double)this.pcx + this.dpdwx * (xr - this.wcx));
    }

    private final int qpowy(double yr) {
        return (int)((double)this.height - ((double)this.pcy + this.dpdwy * (yr - this.wcy)));
    }

    public final int pubPowx(double xr) {
        return this.powx(xr);
    }

    public final int pubPowy(double yr) {
        return this.powy(yr);
    }

    public final Position getWorldPosition(int x, int y) {
        return new Position(this.wopx(x), this.wopy(y));
    }

    public final double pubWopx(int x) {
        return this.wopx(x);
    }

    public final double pubWopy(int y) {
        return this.wopy(y);
    }

    public final int pubPixDx(double dxr) {
        return (int)(this.dpdwx * dxr);
    }

    public final int pubPixDy(double dyr) {
        return (int)(this.dpdwy * dyr);
    }

    public final double dPdX() {
        return this.dpdwx;
    }

    public final double dPdY() {
        return this.dpdwy;
    }

    public final double pubDyDpix() {
        return 1.0 / this.dpdwy;
    }

    public final double pubDxDpix() {
        return 1.0 / this.dpdwx;
    }

    public final double wxLeft() {
        return this.wcx - (double)this.hx / this.dpdwx;
    }

    public final double wxRight() {
        return this.wcx + (double)this.hx / this.dpdwx;
    }

    public final double wyBottom() {
        return this.wcy - (double)this.hy / this.dpdwy;
    }

    public final double wyTop() {
        return this.wcy + (double)this.hy / this.dpdwy;
    }

    private final void enforceAspectRatioY() {
        if (this.xRescalable) {
            this.dpdwx = 1.0 / this.aspectRatio * this.dpdwy;
        } else if (this.yRescalable) {
            this.dpdwy = this.aspectRatio * this.dpdwx;
        }
    }

    private final void enforceAspectRatioX() {
        if (this.yRescalable) {
            this.dpdwy = this.aspectRatio * this.dpdwx;
        } else if (this.xRescalable) {
            this.dpdwx = 1.0 / this.aspectRatio * this.dpdwy;
        }
    }

    private void zoomAbout(double f, int xc, int yc) {
        this.zoomAbout(f, f, xc, yc);
    }

    private void zoomAbout(double fx, double fy, int xc, int yc) {
        this.xZoomAbout(fx, xc);
        this.yZoomAbout(fy, yc);
        if (this.constantAspectRatio) {
            this.enforceAspectRatioY();
        }
        this.rangeChange(3);
    }

    private void xZoomAbout(double f, int xc) {
        double xWorld = this.wopx(xc);
        if (xc > this.leftMargin && this.xRescalable) {
            this.wcx = xWorld + f * (this.wcx - xWorld);
            this.dpdwx /= f;
            if (this.dpdwx > 1.0E7) {
                this.dpdwx = 1.0E7;
            }
        }
    }

    private void yZoomAbout(double f, int yc) {
        double yWorld = this.wopy(yc);
        if (yc < this.height - this.bottomMargin && this.yRescalable) {
            this.wcy = yWorld + f * (this.wcy - yWorld);
            this.dpdwy /= f;
            if (this.dpdwy > 1.0E7) {
                this.dpdwy = 1.0E7;
            }
        }
    }

    public void reframe(Box b) {
        this.setXRange(b.getXmin(), b.getXmax());
        this.setYRange(b.getYmin(), b.getYmax());
        this.notifyRangeChange();
    }

    public void setXRange(double xl, double xh) {
        this.p_setXRange(xl, xh);
    }

    public void setYRange(double yl, double yh) {
        this.p_setYRange(yl, yh);
    }

    private void p_setXRange(double xl, double xh) {
        if (xh < xl) {
            double xt = xh;
            xh = xl;
            xl = xt;
        }
        if (this.xRescalable) {
            if (xh <= xl) {
                xh += 0.5;
                xl -= 0.5;
            }
            this.wcx = 0.5 * (xl + xh);
            if (xh <= xl + 1.0E-7) {
                xh = xl + 1.0E-7;
            }
            this.dpdwx = 2.0 * (double)this.hx / (xh - xl);
        }
        if (this.constantAspectRatio) {
            this.enforceAspectRatioX();
        }
        this.rangeChange(1);
    }

    public void ensureCovers(double xl, double yl, double xh, double yh) {
        if ((xh - xl) * (double)this.hy > (yh - yl) * (double)this.hx) {
            this.p_setYRange(yl, yh);
            this.p_setXRange(xl, xh);
        } else {
            this.p_setXRange(xl, xh);
            this.p_setYRange(yl, yh);
        }
    }

    private void p_setYRange(double yl, double yh) {
        if (yh < yl) {
            double yt = yh;
            yh = yl;
            yl = yt;
        }
        if (this.yRescalable) {
            if (yh <= yl) {
                yl -= 0.5;
                yh += 0.5;
            }
            this.wcy = 0.5 * (yl + yh);
            if (yh <= yl + 1.0E-7) {
                yh = yl + 1.0E-7;
            }
            this.dpdwy = 2.0 * (double)this.hy / (yh - yl);
        }
        if (this.constantAspectRatio) {
            this.enforceAspectRatioY();
        }
        this.rangeChange(2);
    }

    public final double[] getXYXYLimits() {
        double[] range = new double[]{this.wxLeft(), this.wyBottom(), this.wxRight(), this.wyTop()};
        return range;
    }

    public double[] getXRange() {
        double[] d = new double[]{this.wxLeft(), this.wxRight()};
        return d;
    }

    public double[] getYRange() {
        double[] d = new double[]{this.wyBottom(), this.wyTop()};
        return d;
    }

    public final void setXYXYLimits(double xl, double yl, double xh, double yh) {
        if (this.constantAspectRatio) {
            if ((xh - xl) / (double)(this.width - this.leftMargin - this.rightMargin) > (yh - yl) / (double)(this.height - this.topMargin - this.bottomMargin)) {
                this.p_setYRange(yl, yh);
                this.p_setXRange(xl, xh);
            } else {
                this.p_setXRange(xl, xh);
                this.p_setYRange(yl, yh);
            }
        } else {
            this.p_setXRange(xl, xh);
            this.p_setYRange(yl, yh);
        }
    }

    void applyRecordedRange() {
        double dx = 0.1 * (this.vxmax - this.vxmin);
        double dy = 0.1 * (this.vymax - this.vymin);
        double xa = this.vxmin - dx;
        double xb = this.vxmax + dx;
        double ya = this.vymin - dy;
        double yb = this.vymax + dy;
        if (this.vxmin > 1.0E8 && this.vxmax < -1.0E8) {
            this.setXYXYLimits(0.0, 0.0, 1.0, 1.0);
        } else {
            this.setXYXYLimits(xa, ya, xb, yb);
        }
    }

    void boxSelected(int x0, int y0, int x1, int y1) {
        this.p_setXRange(this.wopx(x0), this.wopx(x1));
        this.p_setYRange(this.wopy(y0), this.wopy(y1));
    }

    void zoom(double fac, int xc, int yc) {
        this.zoomAbout(fac, xc, yc);
    }

    void zoom(double xfac, double yfac, int xc, int yc) {
        this.zoomAbout(xfac, yfac, xc, yc);
    }

    void trialPan(int xfrom, int yfrom, int xto, int yto) {
        if (!this.trialPanning) {
            this.wcxtp = this.wcx;
            this.wcytp = this.wcy;
            this.trialPanning = true;
        }
        this.wcx = this.wcxtp - (this.wopx(xto) - this.wopx(xfrom));
        this.wcy = this.wcytp - (this.wopy(yto) - this.wopy(yfrom));
        this.rangeChange(3);
    }

    void permanentPan(int xfrom, int yfrom, int xto, int yto) {
        if (!this.trialPanning) {
            this.wcxtp = this.wcx;
            this.wcytp = this.wcy;
        }
        this.wcx = this.wcxtp - (this.wopx(xto) - this.wopx(xfrom));
        this.wcy = this.wcytp - (this.wopy(yto) - this.wopy(yfrom));
        this.trialPanning = false;
        this.rangeChange(3);
    }

    public int[] getIntPosition(double x, double y) {
        int[] ixy = new int[]{this.powx(x), this.powy(y)};
        return ixy;
    }
}

