/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.catacomb.be.Position;
import org.catacomb.datalish.Box;
import org.catacomb.graph.gui.BaseCanvas;
import org.catacomb.graph.gui.BoxSelectionHandler;
import org.catacomb.graph.gui.ClickZoomHandler;
import org.catacomb.graph.gui.Mouse;
import org.catacomb.graph.gui.MouseHandler;
import org.catacomb.graph.gui.PaintInstructor;
import org.catacomb.graph.gui.Painter;
import org.catacomb.graph.gui.PanHandler;
import org.catacomb.graph.gui.RangeListener;
import org.catacomb.graph.gui.TurnZoomHandler;
import org.catacomb.graph.gui.WorldTransform;
import org.catacomb.interlish.interact.ClickListener;
import org.catacomb.interlish.structure.ModeSettable;
import org.catacomb.report.E;

public class WorldCanvas
extends BaseCanvas
implements ModeSettable {
    static final long serialVersionUID = 1001L;
    protected WorldTransform wt;
    protected Painter painter;
    protected PaintInstructor paintInstructor;
    protected Mouse mouse;
    private BoxSelectionHandler boxSelectionHandler;
    private PanHandler panHandler;
    private TurnZoomHandler turnZoomHandler;
    private ClickZoomHandler clickZoomHandler;
    private MouseHandler[] handlers;
    private boolean antialias = false;
    private boolean tooltips = false;
    Box reframeBox;

    public WorldCanvas(int w, int h) {
        this(w, h, true);
    }

    public WorldCanvas(int w, int h, boolean interactive) {
        super(w, h);
        this.mouse = new Mouse(this, interactive);
        this.wt = new WorldTransform();
        this.wt.setWidth(w);
        this.wt.setHeight(h);
        this.painter = new Painter(this.wt);
        this.addWorldHandlers();
        this.setMouseMode("pan");
    }

    public void setMode(String dom, String mod) {
        if (dom.equals("antialias")) {
            this.antialias = mod.equals("true");
        } else if (dom.equals("mouse")) {
            this.setMouseMode(mod);
        } else {
            E.error("unrecognized mode " + dom);
        }
        this.repaint();
    }

    public void setMode(String dom, boolean b) {
        if (dom.equals("antialias")) {
            this.antialias = b;
        } else if (dom.equals("labels")) {
            this.tooltips = b;
        } else if (dom.equals("showAll")) {
            this.reframe();
        } else {
            E.error("unrecognized mode " + dom);
        }
        this.repaint();
    }

    public void syncSize() {
        this.wt.setWidth(this.getWidth());
        this.wt.setHeight(this.getHeight());
    }

    public void reluctantReframe() {
        Box box;
        if (this.reframeBox == null) {
            this.reframe();
        } else if (this.paintInstructor != null && (box = this.paintInstructor.getLimitBox()) != null && box.differentFrom(this.reframeBox, 0.15)) {
            this.frameToBox(box);
        }
    }

    public void reframe() {
        if (this.paintInstructor == null) {
            E.shortWarning("no paint instructor?");
        } else {
            Box box = this.paintInstructor.getLimitBox();
            this.frameToBox(box);
        }
    }

    private void frameToBox(Box box) {
        if (box == null) {
            E.warning("no limit box returned from " + this.paintInstructor.getClass().getName());
        } else if (box.hasData()) {
            this.reframeBox = box.makeCopy();
            box.pad();
            this.painter.reframe(box);
            this.repaint();
        }
    }

    public boolean showTooltips() {
        return this.tooltips;
    }

    public void setMode(int imode) {
        E.missing();
    }

    public void addRangeListener(RangeListener rl) {
        this.wt.addRangeListener(rl);
    }

    public Painter getPainter() {
        return this.painter;
    }

    WorldTransform getWorldTransform() {
        return this.wt;
    }

    public void prependHandler(MouseHandler mhandler) {
        this.mouse.prependHandler(mhandler);
    }

    public void setClickListener(ClickListener cl) {
        this.mouse.setClickListener(cl);
    }

    public void addWorldHandlers() {
        this.panHandler = new PanHandler();
        this.addHandler(this.panHandler);
        this.clickZoomHandler = new ClickZoomHandler();
        this.addHandler(this.clickZoomHandler);
        this.boxSelectionHandler = new BoxSelectionHandler();
        this.addHandler(this.boxSelectionHandler);
        this.turnZoomHandler = new TurnZoomHandler();
        this.addHandler(this.turnZoomHandler);
        MouseHandler[] ha = new MouseHandler[]{this.panHandler, this.clickZoomHandler, this.boxSelectionHandler, this.turnZoomHandler};
        this.handlers = ha;
    }

    public void setMouseMode(String s) {
        int i = 0;
        while (i < this.handlers.length) {
            this.handlers[i].deactivate();
            ++i;
        }
        if (s == null) {
            E.error("null mouse mode ");
        } else if (s.equals("all")) {
            i = 0;
            while (i < this.handlers.length) {
                this.handlers[i].activate();
                ++i;
            }
        } else if (s.equals("pan")) {
            this.panHandler.simpleActivate();
        } else if (s.equals("zoomIn")) {
            this.clickZoomHandler.activateIn();
        } else if (s.equals("zoomOut")) {
            this.clickZoomHandler.activateOut();
        } else if (s.equals("box")) {
            this.boxSelectionHandler.simpleActivate();
        } else {
            E.error("unhandled mouse mode " + s);
        }
    }

    public void setXRange(double[] lh) {
        this.setXRange(lh[0], lh[1]);
    }

    public void setYRange(double[] lh) {
        this.setYRange(lh[0], lh[1]);
    }

    public void ensureCovers(double[] xr, double[] yr) {
        this.wt.ensureCovers(xr[0], yr[0], xr[1], yr[1]);
        this.wt.notifyRangeChange();
    }

    public void setXRange(double low, double high) {
        this.wt.setXRange(low, high);
        this.wt.notifyRangeChange();
    }

    public void setYRange(double low, double high) {
        this.wt.setYRange(low, high);
        this.wt.notifyRangeChange();
    }

    public void setFixedAspectRatio(double ar) {
        this.wt.setFixedAspectRatio(ar);
    }

    public double[] getXRange() {
        return this.wt.getXRange();
    }

    public double[] getYRange() {
        return this.wt.getYRange();
    }

    public void viewAction(String s) {
        if (s.equals("frame")) {
            this.reframe();
        }
    }

    public void addHandler(MouseHandler mh) {
        this.mouse.addHandler(mh);
    }

    public void fixRanges() {
        this.wt.fixRanges();
    }

    public void setPaintInstructor(PaintInstructor pi) {
        this.paintInstructor = pi;
    }

    public void paintComponent(Graphics g0) {
        this.wt.setWidth(this.getWidth());
        this.wt.setHeight(this.getHeight());
        g0.setColor(this.getDataBackground());
        g0.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g = (Graphics2D)g0;
        double[] dd = this.wt.getYRange();
        this.painter.setGraphics(g);
        this.prePaint(g);
        this.paint2D(g);
        this.postPaint(g);
        this.mouse.echoPaint(g);
    }

    public void prePaint(Graphics2D g) {
    }

    public void postPaint(Graphics2D g) {
    }

    public void applyAAPreference(Graphics2D g) {
        if (this.antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public void paint2D(Graphics2D g) {
        E.info("pw oainting ");
        if (this.paintInstructor != null) {
            this.applyAAPreference(g);
            this.paintInstructor.instruct(this.painter);
        }
    }

    void boxSelected(int x0, int y0, int x1, int y1) {
        this.wt.setCanvasSize(this.getWidth(), this.getHeight());
        this.wt.boxSelected(x0, y0, x1, y1);
        this.repaint();
    }

    void zoom(double fac, int xc, int yc) {
        this.wt.zoom(fac, xc, yc);
        this.repaint();
    }

    void zoom(double xfac, double yfac, int xc, int yc) {
        this.wt.zoom(xfac, yfac, xc, yc);
        this.repaint();
    }

    void trialPan(int xfrom, int yfrom, int xto, int yto) {
        this.wt.trialPan(xfrom, yfrom, xto, yto);
        this.repaint();
    }

    void permanentPan(int xfrom, int yfrom, int xto, int yto) {
        this.wt.permanentPan(xfrom, yfrom, xto, yto);
        this.repaint();
    }

    public void setColorRange(double cmin, double cmax) {
        this.painter.setColorRange(cmin, cmax);
    }

    public void setColorTable(Color[] ac) {
        this.painter.setColorTable(ac);
    }

    public int[] getIntPosition(Position pos) {
        return this.wt.getIntPosition(pos.getX(), pos.getY());
    }
}

