/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.util.ArrayList;
import org.catacomb.graph.gui.DataView;
import org.catacomb.interlish.content.KeyedList;
import org.catacomb.interlish.structure.IDable;
import org.catacomb.interlish.structure.IDd;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewSet
implements IDable {
    String id;
    KeyedList<DataView> views = new KeyedList();
    String latestNew = null;

    public ViewSet() {
    }

    public ViewSet(String s) {
        this();
        this.id = s;
    }

    public KeyedList<? extends IDd> getDataViews() {
        return this.views;
    }

    @Override
    public void setID(String s) {
        this.id = s;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void addView(DataView dv) {
        if (this.views.hasItem(dv.getID())) {
            this.views.remove(dv.getID());
        }
        this.views.add(dv);
    }

    public String newViewName() {
        return this.views.newName("view");
    }

    public DataView getDataView(String s) {
        return this.views.get(s);
    }

    public boolean hasView(String s) {
        return this.views.hasItem(s);
    }

    public void addIfNew(ArrayList<DataView> newViews) {
        boolean added = false;
        this.latestNew = null;
        for (DataView dv : newViews) {
            String sid = dv.getID();
            if (sid == null) {
                E.error("view with no id " + dv);
                continue;
            }
            if (this.hasView(dv.getID())) continue;
            this.views.silentAddItem(dv);
            added = true;
            this.latestNew = dv.getID();
        }
        if (added) {
            this.views.reportChange();
        }
    }

    public String latestAddition() {
        return this.latestNew;
    }

    public void printViews() {
        E.info("all views: " + this.views.printIDs());
    }
}

