/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.graph.gui.Mouse;
import org.catacomb.graph.gui.MouseHandler;

public class TurnZoomHandler
extends MouseHandler {
    private int xc;
    private int yc;
    private int x0;
    private int y0;
    private int x1;
    private int y1;

    public void init(Mouse m) {
        this.xc = m.getX();
        this.yc = m.getY();
        this.x0 = this.xc;
        this.y0 = this.yc;
        this.x1 = this.xc;
        this.y1 = this.yc;
    }

    public void advance(Mouse m) {
        int x = m.getX();
        int y = m.getY();
        if (x <= 1 || x >= m.getCanvasWidth() || y <= 1 || y >= m.getCanvasHeight()) {
            this.setClaimIn();
        }
    }

    public void applyOnDrag(Mouse m) {
        int y;
        int x = m.getX();
        if ((x - this.x1) * (x - this.x1) + ((y = m.getY()) - this.y1) * (y - this.y1) > 64) {
            double a = (this.x1 - this.x0) * (y - this.y0) - (this.y1 - this.y0) * (x - this.x0);
            int d2 = (this.x1 - this.x0) * (this.x1 - this.x0) + (this.y1 - this.y0) * (this.y1 - this.y0);
            if (d2 > 32) {
                double f = Math.exp(0.16 * (a /= (double)d2));
                m.zoom(f, this.xc, this.yc);
            }
            this.x0 = this.x1;
            this.x1 = x;
            this.y0 = this.y1;
            this.y1 = y;
        }
    }
}

