/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.be.Direction;
import org.catacomb.be.Placement;
import org.catacomb.be.Position;
import org.catacomb.datalish.Box;
import org.catacomb.datalish.SceneConfig;
import org.catacomb.datalish.SpriteAnimation;
import org.catacomb.datalish.SpriteData;
import org.catacomb.datalish.SpriteEvents;
import org.catacomb.datalish.SpriteMarker;
import org.catacomb.datalish.SpritePart;
import org.catacomb.datalish.SpritePlacement;
import org.catacomb.datalish.SpriteStore;
import org.catacomb.graph.gui.MoviePaintInstructor;
import org.catacomb.graph.gui.Painter;
import org.catacomb.interlish.content.Polypoint;

public class SpriteMoviePainter
implements MoviePaintInstructor {
    SpriteAnimation movie;
    int lastPainted;
    int frameToPaint;

    public SpriteMoviePainter() {
    }

    public SpriteMoviePainter(SpriteAnimation san) {
        this.setMovie(san);
    }

    public void setMovie(SpriteAnimation sa) {
        this.movie = sa;
    }

    public void setFrame(int ifr) {
        this.frameToPaint = ifr;
    }

    public void advanceToFrame(int ifr) {
        this.frameToPaint = ifr;
        if (this.frameToPaint > this.lastPainted) {
            int i = this.lastPainted + 1;
            while (i <= this.frameToPaint) {
                SceneConfig scene = this.movie.getSceneConfig(i);
                SpriteEvents sevs = scene.getEvents();
                if (sevs != null) {
                    sevs.perform();
                }
                ++i;
            }
        }
    }

    public int getNFrames() {
        int ret = 0;
        if (this.movie != null) {
            ret = this.movie.getNPoint();
        }
        return ret;
    }

    public boolean antialias() {
        return false;
    }

    public void instruct(Painter p) {
        if (this.movie != null) {
            SceneConfig scene = this.movie.getSceneConfig(this.frameToPaint);
            SpritePlacement[] spa = scene.getPlacements();
            SpriteStore spriteStore = this.movie.getSpriteStore();
            SpritePlacement[] spritePlacementArray = spa;
            int n = 0;
            int n2 = spritePlacementArray.length;
            while (n < n2) {
                SpritePlacement sp = spritePlacementArray[n];
                String sid = sp.getID();
                Placement pmt = sp.getPlacement();
                SpriteData sdat = spriteStore.getSprite(sid);
                this.paintSprite(p, sdat, pmt);
                ++n;
            }
            this.lastPainted = this.frameToPaint;
        }
    }

    private void paintSprite(Painter p, SpriteData sdat, Placement pmt) {
        Position pos = pmt.getPosition();
        Direction dir = pmt.getDirection();
        for (SpritePart sp : sdat.getParts()) {
            Polypoint pl = new Polypoint(sp.copyXpts(), sp.copyYpts());
            pl.rotate(dir);
            pl.translate(pos);
            double[] xd = pl.getXPts();
            double[] yd = pl.getYPts();
            if (sp.open()) {
                p.setColor(sp.getLineColor());
                p.drawPolyline(xd, yd);
                continue;
            }
            if (sp.closed()) {
                p.setColor(sp.getLineColor());
                p.drawPolygon(xd, yd);
                continue;
            }
            p.setColor(sp.getFillColor());
            p.fillPolygon(xd, yd);
            p.setColor(sp.getLineColor());
            p.drawPolygon(xd, yd);
        }
        for (SpriteMarker sm : sdat.getMarkers()) {
            p.setColorWhite();
            Position mpos = sm.getPosition().copy();
            mpos.rotateTo(dir);
            mpos.shift(pos);
            p.fillCenteredOval(mpos, 2);
        }
    }

    public Box getLimitBox() {
        Box b = null;
        if (this.movie != null) {
            SpritePlacement[] spa;
            b = this.movie.getBox();
            SpriteStore spriteStore = this.movie.getSpriteStore();
            SceneConfig scene = this.movie.getSceneConfig(0);
            if (scene != null && (spa = scene.getPlacements()) != null) {
                SpritePlacement[] spritePlacementArray = spa;
                int n = 0;
                int n2 = spritePlacementArray.length;
                while (n < n2) {
                    SpritePlacement sp = spritePlacementArray[n];
                    String sid = sp.getID();
                    SpriteData sdat = spriteStore.getSprite(sid);
                    sdat.pushBox(b);
                    ++n;
                }
            }
        }
        return b;
    }

    public String getFrameDescription(int ifr) {
        return this.movie.getFrameDescription(ifr);
    }
}

