/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.graph.gui.Mouse;
import org.catacomb.graph.gui.MouseHandler;

final class PanHandler
extends MouseHandler {
    private int xc;
    private int yc;
    private boolean continuous = false;
    static final int NORMAL = 0;
    static final int SIMPLE = 1;
    int actionMode = 0;

    public void init(Mouse m) {
        this.xc = m.getX();
        this.yc = m.getY();
        if (this.actionMode == 1) {
            if (m.leftButton()) {
                this.setClaimIn();
                this.continuous = true;
            } else {
                this.setClaimOut();
            }
        } else if (m.leftButton()) {
            this.setClaimOut();
        } else if (m.rightButton()) {
            this.continuous = true;
        } else {
            this.setClaimOut();
        }
    }

    public void activate() {
        this.actionMode = 0;
        super.activate();
    }

    public void simpleActivate() {
        this.activate();
        this.actionMode = 1;
    }

    public void advance(Mouse m) {
        int dy;
        int dx = m.getX() - this.xc;
        if (dx * dx + (dy = m.getY() - this.yc) * dy > 100) {
            this.setClaimIn();
        }
    }

    public void applyOnDrag(Mouse m) {
        int x = m.getX();
        int y = m.getY();
        m.trialPan(this.xc, this.yc, x, y);
        this.setFullRepaint();
    }

    public void applyOnRelease(Mouse m) {
        int x = m.getX();
        int y = m.getY();
        m.permanentPan(this.xc, this.yc, x, y);
    }
}

