/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.be.Position;

public abstract class Geom {
    public static final boolean pointIsInside(double[] xb, double[] yb, int x, int y) {
        return Geom.pointIsInside(xb, yb, (double)x, (double)y);
    }

    public static final boolean pointIsInside(double[] xb, double[] yb, double x, double y) {
        int n = xb.length;
        int iwn = 0;
        int i = 0;
        while (i < n) {
            int idir = 0;
            int p = (i + 1) % n;
            if (yb[i] <= y && yb[p] > y) {
                idir = 1;
            }
            if (yb[i] > y && yb[p] <= y) {
                idir = -1;
            }
            if (idir != 0) {
                double f = (y - yb[i]) / (yb[p] - yb[i]);
                double xc = f * xb[p] + (1.0 - f) * xb[i];
                int isid = xc > x ? 1 : -1;
                iwn += isid * idir;
            }
            ++i;
        }
        return iwn != 0;
    }

    public static double[][] makeLineBoundary(double[] xpts, double[] ypts) {
        int np = xpts.length;
        double[][] ret = new double[2][4 + 3 * (np - 2)];
        double[] xret = ret[0];
        double[] yret = ret[1];
        int nr = xret.length - 1;
        int ic = 0;
        int iac = 0;
        double f = 0.15;
        int i = 0;
        while (i < np) {
            int ifb;
            int ifa = i - 1;
            if (ifa < 0) {
                ifa = 0;
            }
            if ((ifb = i + 1) >= np - 1) {
                ifb = np - 1;
            }
            double dxa = xpts[ifa] - xpts[ifa + 1];
            double dya = ypts[ifa] - ypts[ifa + 1];
            double dxb = xpts[ifb] - xpts[ifb - 1];
            double dyb = ypts[ifb] - ypts[ifb - 1];
            double la = Math.sqrt(dxa * dxa + dya * dya) + 1.0E-8;
            double lb = Math.sqrt(dxb * dxb + dyb * dyb) + 2.0E-8;
            double vxa = dxa / la;
            double vya = dya / la;
            double vxb = dxb / lb;
            double vyb = dyb / lb;
            double cosTheta = vxa * vxb + vya * vyb;
            double sinHalfTheta = Math.sqrt((1.0 - cosTheta) / 2.0);
            double vecp = vxa * vyb - vxb * vya;
            double vxo = vya - vyb;
            double vyo = -vxa + vxb;
            double lo = Math.sqrt(vxo * vxo + vyo * vyo);
            vxo /= lo;
            vyo /= lo;
            double fe = 1.0 / sinHalfTheta;
            fe *= f;
            double xc = xpts[i];
            double yc = ypts[i];
            if (i == 0 || i == np - 1) {
                xret[ic] = xc + fe * vxo;
                yret[ic] = yc + fe * vyo;
                ++ic;
                xret[nr - iac] = xc - fe * vxo;
                yret[nr - iac] = yc - fe * vyo;
                ++iac;
            } else if (vecp < 0.0) {
                xret[ic] = xc + fe * vxo;
                yret[ic] = yc + fe * vyo;
                ++ic;
                xret[nr - iac] = xc - f * vya;
                yret[nr - iac] = yc + f * vxa;
                xret[nr - ++iac] = xc + f * vyb;
                yret[nr - iac] = yc - f * vxb;
                ++iac;
            } else {
                xret[ic] = xc + f * vya;
                yret[ic] = yc - f * vxa;
                xret[++ic] = xc - f * vyb;
                yret[ic] = yc + f * vxb;
                ++ic;
                xret[nr - iac] = xc - fe * vxo;
                yret[nr - iac] = yc - fe * vyo;
                ++iac;
            }
            ++i;
        }
        return ret;
    }

    public static Position centerOfGravity(double[] xpts, double[] ypts) {
        int np = xpts.length;
        double xc = 0.0;
        double yc = 0.0;
        int i = 0;
        while (i < np) {
            xc += xpts[i];
            yc += ypts[i];
            ++i;
        }
        return new Position(xc /= (double)np, yc /= (double)np);
    }

    public static double distanceBetween(Position a, Position b) {
        double dx = b.getX() - a.getX();
        double dy = b.getY() - a.getY();
        double ret = Math.sqrt(dx * dx + dy * dy);
        return ret;
    }

    public static double[][] innerPolygon(double[] x, double[] y) {
        int n = x.length;
        double[][] ret = new double[2][n];
        double cx = 0.0;
        double cy = 0.0;
        int i = 0;
        while (i < n) {
            cx += x[i];
            cy += y[i];
            ++i;
        }
        cx /= (double)n;
        cy /= (double)n;
        i = 0;
        while (i < n) {
            ret[0][i] = cx + 0.9 * (x[i] - cx);
            ret[1][i] = cy + 0.9 * (y[i] - cy);
            ++i;
        }
        return ret;
    }
}

