/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.graph.gui.Mouse;
import org.catacomb.graph.gui.MouseHandler;

final class ClickZoomHandler
extends MouseHandler {
    private int xc;
    private int yc;
    double xfac = 1.0;
    double yfac = 1.0;
    static final int NORMAL = 1;
    static final int IN = 2;
    static final int OUT = 3;
    int actionMode;

    public void activate() {
        this.actionMode = 1;
        super.activate();
    }

    public void activateIn() {
        this.activate();
        this.actionMode = 2;
    }

    public void activateOut() {
        this.activate();
        this.actionMode = 3;
    }

    public void init(Mouse m) {
        this.xc = m.getX();
        this.yc = m.getY();
        double zfac = 1.0;
        this.xfac = 1.0;
        this.yfac = 1.0;
        if (this.actionMode == 2) {
            zfac = 0.7;
            this.setClaimIn();
        } else if (this.actionMode == 3) {
            zfac = 1.4285714285714286;
            this.setClaimIn();
        } else if (m.leftButton()) {
            zfac = 0.7;
        } else if (m.rightButton()) {
            zfac = 1.4285714285714286;
        } else {
            this.setClaimOut();
        }
        if (this.xc > 30) {
            this.xfac = zfac;
        }
        if (this.yc < m.getCanvasHeight() - 30) {
            this.yfac = zfac;
        }
    }

    public void advance(Mouse m) {
        int dy;
        int dx;
        if (this.actionMode == 1 && (dx = m.getX() - this.xc) * dx + (dy = m.getY() - this.yc) * dy > 100) {
            this.setClaimOut();
        }
    }

    public void release(Mouse m) {
        this.setClaimIn();
    }

    public void applyOnRelease(Mouse m) {
        m.zoom(this.xfac, this.yfac, this.xc, this.yc);
    }
}

