/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import org.catacomb.graph.gui.AboveBelowSplitAxisPanelUI;
import org.catacomb.graph.gui.AboveBelowSplitPanelUI;
import org.catacomb.graph.gui.BasePanel;
import org.catacomb.graph.gui.CornerPanel;
import org.catacomb.graph.gui.DataDisplay;
import org.catacomb.graph.gui.GraphColors;
import org.catacomb.graph.gui.VerticalAxisGraphDivider;

public class AboveBelowSplitPanel
extends BasePanel
implements ComponentListener {
    static final long serialVersionUID = 1001L;
    AboveBelowSplitPanel follower;
    JSplitPane jSplitPane;
    boolean ignoreMoves = false;
    boolean drawDivider = false;
    BasePanel ctop;
    VerticalAxisGraphDivider dependentDivider;
    GraphColors gcols;

    public AboveBelowSplitPanel(BasePanel c1, BasePanel c2, GraphColors gc) {
        this.gcols = gc;
        this.ctop = c1;
        boolean CONTINUOUS_LAYOUT = true;
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.jSplitPane = new JSplitPane(0, CONTINUOUS_LAYOUT, c1, c2);
        if (c2 instanceof CornerPanel) {
            this.jSplitPane.setUI(new AboveBelowSplitAxisPanelUI(gc));
        } else {
            this.jSplitPane.setUI(new AboveBelowSplitPanelUI(gc));
        }
        this.jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.jSplitPane.setDividerSize(3);
        this.add(this.jSplitPane);
        if (DataDisplay.interactive) {
            c1.addComponentListener(this);
        }
    }

    public void setDependentDivider(VerticalAxisGraphDivider agd) {
        this.dependentDivider = agd;
    }

    public void setBg(Color c) {
        this.jSplitPane.setBackground(c);
    }

    public void setDividerSize(int n) {
        this.jSplitPane.setDividerSize(n);
    }

    public void setResizeWeight(double d) {
        this.jSplitPane.setResizeWeight(d);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (!this.ignoreMoves) {
            this.sliderMoved();
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void applyLAF() {
    }

    public void setSplitPanelFollower(AboveBelowSplitPanel absp) {
        this.follower = absp;
        this.follower.follow(this);
    }

    public void sliderMoved() {
        if (this.follower != null) {
            this.follower.follow(this);
        }
        if (this.dependentDivider != null) {
            this.dependentDivider.repaint();
        }
    }

    public int getDividerLocation() {
        int idl = this.jSplitPane.getDividerLocation();
        if (idl < 0) {
            idl = this.getHeight() - 36;
        }
        return idl;
    }

    public void setDividerLocation(int dloc) {
        this.jSplitPane.setDividerLocation(dloc);
    }

    public void follow(AboveBelowSplitPanel absrc) {
        this.ignoreMoves = true;
        int srcloc = absrc.getDividerLocation();
        int iloc = this.jSplitPane.getDividerLocation();
        if (iloc != srcloc) {
            this.jSplitPane.setDividerLocation(srcloc);
        }
        this.ignoreMoves = false;
    }
}

