/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import org.catacomb.be.Position;
import org.catacomb.graph.drawing.Shape;
import org.catacomb.graph.gui.AbsLocated;
import org.catacomb.graph.gui.PickablePoint;

public class ShapePoint
implements AbsLocated {
    Shape parentShape;
    Position pAbs;
    Position pCache;
    PickablePoint pickablePoint;
    String type;
    int index;

    public ShapePoint(Shape parent, Position p, int icol) {
        this.parentShape = parent;
        this.pAbs = new Position(p);
        this.pCache = new Position(p);
        this.pickablePoint = new PickablePoint(p, this, icol);
    }

    public void setColor(int icol) {
        this.pickablePoint.setColor(icol);
    }

    public void setType(String s) {
        this.type = s;
    }

    public String getType() {
        return this.type;
    }

    public boolean isType(String s) {
        return this.type != null && this.type.equals(s);
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public Shape getParent() {
        return this.parentShape;
    }

    public void shiftFromCache(Position p) {
        this.pAbs.set(this.pCache);
        this.pAbs.add(p);
    }

    public void setPosition(Position p) {
        this.pAbs.set(p);
        this.parentShape.flagPointMoved();
    }

    public Position getAbsolutePosition() {
        return this.pAbs;
    }

    public Position getPosition() {
        return this.pAbs;
    }

    public PickablePoint getPickablePoint() {
        return this.pickablePoint;
    }

    public void cachePosition() {
        this.pCache.set(this.getPosition());
    }

    public Position getCachedPosition() {
        return this.pCache;
    }
}

