/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import org.catacomb.graph.drawing.DrawingPainter;
import org.catacomb.graph.drawing.IconImage;
import org.catacomb.graph.drawing.VectorIcon;
import org.catacomb.graph.gui.Painter;
import org.catacomb.graph.gui.WorldTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconImageCache {
    static IconImageCache cache;
    HashMap<VectorIcon, IconImage> image32x32HM = new HashMap();
    HashMap<VectorIcon, IconImage> image48x48HM = new HashMap();

    public static IconImageCache getCache() {
        if (cache == null) {
            cache = new IconImageCache();
        }
        return cache;
    }

    public IconImage getImage32x32(VectorIcon vi) {
        return this.getImage(this.image32x32HM, vi, 32, 32);
    }

    public IconImage getImage48x48(VectorIcon vi) {
        return this.getImage(this.image48x48HM, vi, 48, 48);
    }

    private IconImage getImage(HashMap<VectorIcon, IconImage> hm, VectorIcon vi, int nx, int ny) {
        IconImage iim;
        IconImage ret = null;
        if (hm.containsKey(vi) && (iim = hm.get(vi)).getTouchTime().isBefore(vi.getTouchTime())) {
            ret = iim;
        }
        if (ret == null) {
            ret = this.makeImage(vi, nx, ny);
            ret.cacheAsFile(vi.hashCode());
            this.image32x32HM.put(vi, ret);
        }
        return ret;
    }

    public IconImage makeImage(VectorIcon vi, int nx, int ny) {
        WorldTransform wt = new WorldTransform();
        wt.setXRange(-1.2, 1.2);
        wt.setYRange(-1.2, 1.2);
        Painter painter = new Painter(wt);
        BufferedImage transim = new BufferedImage(nx, ny, 2);
        wt.setWidth(nx);
        wt.setHeight(ny);
        wt.setXRange(-1.2, 1.2);
        wt.setYRange(-1.2, 1.2);
        DrawingPainter dp = new DrawingPainter();
        painter.setGraphics(transim.createGraphics());
        dp.instruct(painter, vi, 0.0, 0.0, 1.0);
        return new IconImage(transim);
    }
}

