/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import java.awt.Color;
import org.catacomb.be.ReReferencable;
import org.catacomb.graph.drawing.Shape;
import org.catacomb.graph.gui.Painter;
import org.catacomb.report.E;

public abstract class FixedDrawingComponent
implements ReReferencable,
Cloneable {
    public String lineColor;
    public String lineWidth;
    protected Color p_color = Color.black;
    protected double p_width = 1.0;
    private int p_widthStyle;
    public static final int PIXELS = 0;
    public static final int RELATIVE = 1;
    public String fillColor;
    private Color p_fill;
    private int p_closure;
    public static final int OPEN = 1;
    public static final int CLOSED = 2;
    public static final int FILLED = 3;

    public FixedDrawingComponent copy() {
        Object ret = null;
        try {
            ret = this.clone();
        }
        catch (Exception ex) {
            E.error("whats this " + ex);
        }
        return (FixedDrawingComponent)ret;
    }

    public boolean isWrapper() {
        return false;
    }

    public void setColor(Color c) {
        this.p_color = c;
    }

    public void setWidth(double d) {
        this.p_width = d;
        this.p_widthStyle = 0;
    }

    public Color getColor() {
        return this.p_color;
    }

    public void setLineColor(Color c) {
        this.p_color = c;
    }

    public void setLineWidth(double d) {
        this.p_width = d;
    }

    public double getWidth() {
        return this.p_width;
    }

    public boolean widthIsPixels() {
        return this.p_widthStyle == 0;
    }

    public void setFillColor(Color c) {
        this.p_fill = c;
        this.p_closure = 3;
    }

    public Color getFillColor() {
        return this.p_fill;
    }

    public abstract void instruct(Painter var1, double var2, double var4, double var6);

    public void reReference() {
        this.p_widthStyle = 0;
        this.p_width = this.parseWidth(this.lineWidth);
        this.p_color = this.parseColor(this.lineColor);
        if (this.fillColor == null) {
            this.p_closure = 2;
        } else {
            this.p_closure = 3;
            this.p_fill = this.parseColor(this.fillColor);
        }
    }

    public boolean isOpen() {
        return this.p_closure == 1;
    }

    public boolean isClosed() {
        return this.p_closure == 2;
    }

    public boolean isFilled() {
        return this.p_closure == 3;
    }

    public void setClosed() {
        this.p_closure = 2;
    }

    public void setOpen() {
        this.p_closure = 1;
    }

    public void setFilled() {
        this.p_closure = 3;
    }

    public Color parseColor(String s) {
        Color ret = Color.black;
        if (s != null && s.startsWith("#") && s.length() == 7) {
            String s1 = s.substring(1, s.length());
            int icol = Integer.parseInt(s1, 16);
            ret = new Color(icol);
        } else if (s != null && s.length() != 0) {
            E.error(" - cant read color " + s);
        }
        return ret;
    }

    public int parseWidthStyle(String w) {
        int iret = 0;
        if (w != null) {
            iret = (w = w.trim()).endsWith("px") ? 0 : 1;
        }
        return iret;
    }

    public double parseWidth(String w) {
        double ret = 1.0;
        if (w != null) {
            if ((w = w.trim()).endsWith("px")) {
                w = w.substring(0, w.length() - 2);
            }
            ret = new Double(w);
        }
        return ret;
    }

    public Shape makeShape() {
        Shape shp = new Shape();
        shp.setFillColor(Color.black);
        if (this.isClosed()) {
            shp.setClosure(1);
        } else if (this.isOpen()) {
            shp.setClosure(0);
        } else if (this.isFilled()) {
            shp.setClosure(2);
            shp.setFillColor(this.getFillColor());
        }
        shp.setLineColor(this.p_color);
        shp.setLineWidth(this.p_width);
        this.applyToShape(shp);
        shp.makePoints();
        shp.syncArrays();
        return shp;
    }

    public abstract void applyToShape(Shape var1);
}

