/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.xtext.edit;

import java.awt.Color;
import java.awt.Graphics2D;
import org.catacomb.druid.swing.DTextCanvas;
import org.catacomb.druid.swing.dnd.Region;
import org.catacomb.druid.swing.dnd.RegionBoard;
import org.catacomb.druid.xtext.base.WordBlock;
import org.catacomb.druid.xtext.canvas.FontStore;
import org.catacomb.druid.xtext.data.PageDataStore;
import org.catacomb.druid.xtext.data.XType;
import org.catacomb.druid.xtext.data.XTypeStore;
import org.catacomb.interlish.content.IntPosition;
import org.catacomb.interlish.structure.TextDisplayed;
import org.catacomb.interlish.structure.TextPainter;
import org.catacomb.report.E;

public class XTypeTree
extends RegionBoard
implements TextPainter {
    XTypeStore typeStore = XTypeStore.instance();
    XType selectedType;
    XType hoverType;
    PageDataStore pageDataStore;

    public XTypeTree(DTextCanvas c) {
        super(c);
        this.canvas.setTextPainter(this);
    }

    public IntPosition getScreenPosition() {
        return this.canvas.getScreenPosition();
    }

    public void setSelectedType(XType xt) {
        this.selectedType = xt;
    }

    public void repaint() {
        this.canvas.repaint();
    }

    public void paintText(Graphics2D g) {
        this.clearRegions();
        g.setColor(Color.black);
        int ioff = 26;
        int joff = 20;
        for (XType xt : this.typeStore.getTypes()) {
            g.setFont(FontStore.instance().getDefaultFont());
            this.drawType(g, ioff, joff, xt, "type");
            int xr = ioff - 18;
            if (xt.hasFields()) {
                if (xt.isExpanded()) {
                    g.drawString(" - ", xr, joff);
                    this.addRegion(xr, joff + 4, 18, 16, xt, "collapse", 0);
                } else {
                    g.drawString(" + ", ioff - 18, joff);
                    this.addRegion(xr, joff + 4, 18, 16, xt, "expand", 0);
                }
                joff += 16;
                if (!xt.isExpanded()) continue;
                g.setFont(FontStore.instance().getDefaultItalicFont());
                for (XType subt : xt.getSubtypes()) {
                    this.drawType(g, ioff + 16, joff, subt, "subtype");
                    joff += 16;
                }
                continue;
            }
            joff += 16;
        }
        this.fullTextHeight = joff;
    }

    private void drawType(Graphics2D g, int ioff, int joff, XType xt, String tag) {
        if (xt == this.selectedType) {
            g.setColor(Color.yellow);
            g.fillRect(0, joff - 12, this.canvas.getWidth(), 16);
        }
        g.setColor(Color.black);
        g.drawString(xt.getID(), ioff, joff);
        this.addRegion(ioff, joff + 4, 60, 16, xt, tag, 3);
    }

    public void regionClicked(Region reg) {
        String tag = reg.getTag();
        if (tag != null) {
            if (tag.equals("expand")) {
                ((XType)reg.getRef()).expand();
            } else if (tag.equals("collapse")) {
                ((XType)reg.getRef()).collapse();
            } else if (tag.equals("type")) {
                this.selectedType = (XType)reg.getRef();
                this.notifyChange(this.selectedType);
            } else {
                E.error("doint know " + tag);
            }
        }
        this.repaint();
    }

    public void hover(Object oa) {
        if (oa instanceof XType) {
            this.hoverType = (XType)oa;
            this.hoverType.expand();
        } else {
            this.hoverType = null;
        }
    }

    public void dropOn(Object src, Region reg) {
        if ("_global".equals(reg.getTag())) {
            this.dropGeneral(src);
        } else {
            Object tgt = reg.getRef();
            if (src instanceof WordBlock && tgt instanceof XType) {
                WordBlock tbl = (WordBlock)src;
                XType xt = (XType)tgt;
                this.pageDataStore.addItem(xt, tbl.getExtendedText());
                while (tbl != null) {
                    tbl.setType(xt);
                    tbl = tbl.getLinkee();
                }
            } else {
                E.error("wrong type  -ignoring drop of " + src + " on " + tgt);
            }
            this.repaint();
        }
    }

    public void emptyDrop(Object src) {
        this.dropGeneral(src);
    }

    public void dropGeneral(Object src) {
        if (src instanceof TextDisplayed) {
            String txt = ((TextDisplayed)src).getDisplayText();
            XType xt = new XType(txt);
            this.typeStore.addIfNew(xt);
            if (src instanceof WordBlock) {
                ((WordBlock)src).weakSetType(this.typeStore.getTypeType());
            }
        } else {
            E.error("can only accept text displayed, not " + src);
        }
        this.repaint();
    }

    public void setPageDataStore(PageDataStore pdStore) {
        this.pageDataStore = pdStore;
    }
}

