/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.xtext.canvas;

import java.awt.Font;
import java.awt.Graphics;
import java.util.HashMap;
import org.catacomb.report.E;

public class FontStore {
    HashMap<String, Font> fontHM = new HashMap();
    Font activeFont = new Font("sanserif", 0, 12);
    Font defaultFont;
    Font defaultItalicFont;
    Font h2Font = new Font("sanserif", 1, 14);
    Font boldFont = new Font("sanserif", 1, 12);
    static FontStore p_instance;

    private FontStore() {
    }

    public static FontStore instance() {
        if (p_instance == null) {
            p_instance = new FontStore();
        }
        return p_instance;
    }

    public Font getFont(String fam, String sty, String siz) {
        String key = String.valueOf(fam) + "-" + sty + "-" + siz;
        int isiz = 12;
        if (siz == null) {
            E.warning("null size in get font ");
        } else {
            isiz = Integer.parseInt(siz);
        }
        int isty = 0;
        if (sty == null) {
            E.warning("null style ");
        } else if (!sty.equals("plain")) {
            if (sty.equals("bold")) {
                isty = 1;
            } else if (sty.equals("italic")) {
                isty = 2;
            } else {
                E.error("unrecognized style " + sty);
            }
        }
        return this.getFont(fam, isty, isiz, key);
    }

    public Font getFont(String fam, int isty, int isiz, String key) {
        Font ret = null;
        if (this.fontHM.containsKey(key)) {
            ret = this.fontHM.get(key);
        } else {
            if (fam == null) {
                E.warning("null family in get font ");
                fam = "serif";
            }
            ret = new Font(fam, isty, isiz);
            if (key != null) {
                this.fontHM.put(key, ret);
            }
        }
        return ret;
    }

    public int stringWidth(Graphics g, String text) {
        return g.getFontMetrics().stringWidth(text);
    }

    public Font getActiveFont() {
        return this.activeFont;
    }

    public Font getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.getFont("sansserif", 0, 12, null);
        }
        return this.defaultFont;
    }

    public Font getDefaultItalicFont() {
        if (this.defaultItalicFont == null) {
            this.defaultItalicFont = this.getFont("sansserif", 2, 12, null);
        }
        return this.defaultItalicFont;
    }

    public Font getH2Font() {
        return this.h2Font;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }
}

