/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.util.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import org.catacomb.druid.util.tree.ArrayListNode;
import org.catacomb.druid.util.tree.RelationNode;
import org.catacomb.druid.util.tree.Trawler;
import org.catacomb.interlish.structure.PivotedTree;
import org.catacomb.interlish.structure.Related;
import org.catacomb.interlish.structure.SingleParent;
import org.catacomb.interlish.structure.TreeChangeReporter;
import org.catacomb.interlish.structure.TreeNode;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationTree
implements PivotedTree {
    ArrayListNode rootNode;
    HashMap<Related, RelationNode> peers;
    HashSet<String> relationTypes;
    String[][] pivotOrders;
    String[] pivotNames;
    int iPivot;
    int rootPolicy = 3;
    TreeChangeReporter tcReporter;

    public RelationTree(ArrayList<Related> coll) {
        this.init(coll);
        this.setDefaultPivotOrders();
        this.build(0);
    }

    public RelationTree(SingleParent sp) {
        ArrayList<Related> coll = Trawler.trawlChildren(sp);
        this.init(coll);
        this.setDefaultPivotOrders();
        this.build(0);
    }

    @Override
    public TreeNode getRoot() {
        return this.rootNode;
    }

    public void setRootPolicy(int ipol) {
        this.rootPolicy = ipol;
    }

    @Override
    public int getRootPolicy() {
        return this.rootPolicy;
    }

    public String getPivotRelation() {
        return this.pivotNames[this.iPivot];
    }

    public void init(ArrayList<Related> coll) {
        this.peers = new HashMap();
        this.relationTypes = new HashSet();
        ArrayList<RelationNode> nodes = this.addAll(coll);
        this.resolveAll(nodes);
        String[] sa = this.relationTypes.toArray(new String[0]);
        this.setPivotNames(sa);
    }

    private ArrayList<RelationNode> addAll(ArrayList<Related> coll) {
        ArrayList<RelationNode> arl = new ArrayList<RelationNode>();
        for (Related related : coll) {
            RelationNode rnode = new RelationNode(null, related);
            this.peers.put(related, rnode);
            arl.add(rnode);
        }
        return arl;
    }

    private void resolveAll(ArrayList<RelationNode> coll) {
        for (RelationNode rnode : coll) {
            rnode.resolve(this.peers, this.relationTypes);
        }
    }

    private void newItem(Related parent, Related child) {
        RelationNode rnode = new RelationNode((Object)parent, child);
        this.peers.put(child, rnode);
        rnode.resolve(this.peers, this.relationTypes);
        if (this.tcReporter != null) {
            this.tcReporter.nodeAddedUnder((RelationNode)rnode.getParent(), rnode);
        }
    }

    public void newBranch(Related parent, Related child) {
        if (child instanceof SingleParent) {
            ArrayList<Related> coll = Trawler.trawlChildren((SingleParent)child);
            ArrayList<RelationNode> nodes = this.addAll(coll);
            this.resolveAll(nodes);
        } else {
            this.newItem(parent, child);
        }
        this.build(this.iPivot);
    }

    public void childRemoved(Related parent, Related child) {
        RelationNode rnParent = this.peers.get(parent);
        RelationNode rnChild = this.peers.get(child);
        this.peers.remove(child);
        this.build(this.iPivot);
        if (this.tcReporter != null) {
            this.tcReporter.nodeRemoved(rnParent, rnChild);
        }
    }

    public void setDefaultPivotOrders() {
        String[] sa1 = this.relationTypes.toArray(new String[0]);
        String[] sa2 = new String[sa1.length];
        int i = 0;
        while (i < sa1.length) {
            sa2[i] = sa1[sa1.length - 1 - i];
            ++i;
        }
        String[][] sa = new String[][]{sa1, sa2};
        this.setPivotOrders(sa);
    }

    public void setPivotOrders(String[][] saa) {
        this.pivotOrders = saa;
    }

    @Override
    public String[] getPivotNames() {
        if (this.pivotNames == null) {
            String[] sa = new String[]{"pivot 1", "pivot 2"};
            this.setPivotNames(sa);
        }
        return this.pivotNames;
    }

    public void setPivotNames(String[] sa) {
        this.pivotNames = sa;
    }

    @Override
    public void repivot(String s) {
        int ibo = 0;
        String[] sa = this.getPivotNames();
        int i = 0;
        while (i < sa.length) {
            if (sa[i].equals(s)) {
                ibo = i;
            }
            ++i;
        }
        this.build(ibo);
    }

    public void build(int pivotOrder) {
        if (pivotOrder >= this.pivotOrders.length) {
            System.out.println("WARNING - requested non-existent pivot order " + pivotOrder);
            pivotOrder = 0;
        }
        this.iPivot = pivotOrder;
        ArrayList<RelationNode> rest = new ArrayList<RelationNode>();
        rest.addAll(this.peers.values());
        for (RelationNode rn : rest) {
            rn.clearChildren();
        }
        String[] apo = this.pivotOrders[pivotOrder];
        String srel = null;
        if (apo.length > 0) {
            srel = apo[0];
        }
        ArrayList<RelationNode> roots = this.getRoots(rest, srel);
        if (this.rootNode == null) {
            this.rootNode = new ArrayListNode(null, "root");
        }
        this.rootNode.setChildren(roots);
        if (!rest.isEmpty()) {
            ArrayListNode aln = new ArrayListNode(this.rootNode, "other");
            aln.setChildren(rest);
            this.rootNode.addChild(aln);
        }
    }

    public void treeify(ArrayList<RelationNode> roots, ArrayList<RelationNode> rest, String rel) {
        for (RelationNode rnode : roots) {
            rnode.subtreeify(null, rest, rel);
        }
    }

    private ArrayList<RelationNode> getRoots(ArrayList<RelationNode> rest, String rel) {
        if (rel != null) {
            ListIterator<RelationNode> nodeiter = rest.listIterator();
            while (nodeiter.hasNext()) {
                RelationNode rnode = nodeiter.next();
                if (!rnode.fileAway(rel)) continue;
                nodeiter.remove();
            }
        }
        ArrayList<RelationNode> rwc = new ArrayList<RelationNode>();
        ListIterator<RelationNode> restiter = rest.listIterator();
        while (restiter.hasNext()) {
            RelationNode rnode = restiter.next();
            if (!rnode.hasChildren()) continue;
            rwc.add(rnode);
            restiter.remove();
        }
        return rwc;
    }

    public Object[] getPathTo(Related child) {
        ArrayList<ArrayListNode> retal = new ArrayList<ArrayListNode>();
        Object[] ret = null;
        RelationNode rnode = this.peers.get(child);
        if (rnode == null) {
            E.warning("relation tree has no peer for " + child + " ?");
        } else {
            String srel = this.getPivotRelation();
            rnode = rnode.getParent(srel);
            while (rnode != null) {
                retal.add(0, rnode);
                rnode = rnode.getParent(srel);
            }
            retal.add(0, this.rootNode);
            ret = retal.toArray();
        }
        return ret;
    }

    @Override
    public void setTreeChangeReporter(TreeChangeReporter tcr) {
        this.tcReporter = tcr;
    }

    @Override
    public Object[] getObjectPath(String s, boolean b) {
        E.missing();
        return null;
    }
}

