/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing.dnd;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.image.BufferedImage;
import org.catacomb.druid.swing.DTextCanvas;
import org.catacomb.druid.swing.dnd.DdndTransferable;
import org.catacomb.druid.swing.dnd.DragAndDrop;
import org.catacomb.druid.swing.dnd.Region;
import org.catacomb.druid.swing.dnd.RegionBoard;

public class RegionDragSource
implements DragSourceListener,
DragSourceMotionListener,
DragGestureListener {
    DragSource source;
    DragGestureRecognizer recognizer;
    RegionBoard regionBoard;
    DTextCanvas sourceCanvas;

    public RegionDragSource(RegionBoard rb, int actions) {
        this.regionBoard = rb;
        this.sourceCanvas = rb.getCanvas();
        this.source = new DragSource();
        this.source.addDragSourceMotionListener(this);
        this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceCanvas, actions, this);
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Region reg = this.regionBoard.getHoverRegion();
        if (reg != null) {
            this.initiateDrag(reg, dge.getDragOrigin(), dge);
        }
    }

    public void initiateDrag(Region reg, Point ptDragOrigin, DragGestureEvent trigger) {
        String sdrag = reg.getText();
        DdndTransferable transferable = new DdndTransferable(null);
        Rectangle raPath = new Rectangle(reg.getX(), reg.getY(), reg.getW(), reg.getH());
        int rw = (int)raPath.getWidth();
        int rh = (int)raPath.getHeight();
        BufferedImage dragImg = new BufferedImage(rw, rh, 2);
        Graphics2D g2 = dragImg.createGraphics();
        rw = g2.getFontMetrics().stringWidth(sdrag) + 8;
        dragImg = new BufferedImage(rw, rh, 2);
        g2 = dragImg.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
        g2.setColor(Color.white);
        g2.fillRect(0, 0, rw, rh);
        g2.setComposite(AlphaComposite.getInstance(2, 1.0f));
        g2.setColor(Color.blue);
        g2.drawString(sdrag, 4, 16);
        Point imgOffset = new Point(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
        DragAndDrop.getDnD().setDragSource(reg.getRef());
        DragAndDrop.getDnD().setDragImage(dragImg, imgOffset);
        this.source.startDrag(trigger, Cursor.getPredefinedCursor(12), dragImg, imgOffset, transferable, this);
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
        System.out.println("Action: " + dsde.getDropAction());
        System.out.println("Target Action: " + dsde.getTargetActions());
        System.out.println("User Action: " + dsde.getUserAction());
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragMouseMoved(DragSourceDragEvent dsde) {
    }
}

