/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing.dnd;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.catacomb.druid.swing.DTextCanvas;
import org.catacomb.druid.swing.dnd.Region;
import org.catacomb.druid.swing.dnd.RegionListener;
import org.catacomb.druid.swing.dnd.RegionStore;
import org.catacomb.report.E;

public class ClickableRegionStore
extends RegionStore
implements MouseListener,
MouseMotionListener {
    DTextCanvas canvas;
    RegionListener regionListener;

    public ClickableRegionStore(DTextCanvas c) {
        this.canvas = c;
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
    }

    public void setRegionListener(RegionListener rl) {
        this.regionListener = rl;
    }

    public void mouseClicked(MouseEvent e) {
        this.canvas.requestFocus();
    }

    public void mousePressed(MouseEvent e) {
        this.press(e.getX(), e.getY());
    }

    public void mouseReleased(MouseEvent e) {
        Region reg = this.getPressRegion();
        if (reg != null) {
            if (this.regionListener != null) {
                this.regionListener.regionClicked(reg);
            } else {
                E.info("region clicked but no listener " + reg);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        Region rpr = this.getHoverRegion();
        this.hoverOver(e.getX(), e.getY());
        Region rnw = this.getHoverRegion();
        if (rpr == null && rnw != null || rpr != null && rnw == null || rpr != null && rpr != rnw) {
            Graphics g = this.canvas.getGraphics();
            if (rpr != null) {
                this.unecho(rpr);
            }
            if (rnw != null) {
                if (rnw.draggable()) {
                    g.setColor(Color.magenta);
                    g.drawRect(rnw.getX(), rnw.getY(), rnw.getW(), rnw.getH());
                    g.drawRect(rnw.getX() + 1, rnw.getY() + 1, rnw.getW() - 2, rnw.getH() - 2);
                } else if (rnw.clickable()) {
                    g.setColor(Color.orange);
                    g.drawRect(rnw.getX(), rnw.getY(), rnw.getW(), rnw.getH());
                    g.drawRect(rnw.getX() + 1, rnw.getY() + 1, rnw.getW() - 2, rnw.getH() - 2);
                }
            }
        }
    }

    public void unecho(Region r) {
        Rectangle rect = new Rectangle(r.getX(), r.getY(), r.getW() + 1, r.getH() + 1);
        this.canvas.paintImmediately(rect);
    }

    public void clearRegions() {
        this.clear();
    }
}

