/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.border.Border;
import org.catacomb.druid.swing.BorderUtil;
import org.catacomb.druid.swing.DBaseButton;
import org.catacomb.interlish.structure.MouseSource;
import org.catacomb.util.ColorUtil;

public class DToggleButton
extends DBaseButton
implements ActionListener,
MouseListener,
MouseSource {
    boolean state;
    Color bgColor;
    private ImageIcon offIcon;
    private ImageIcon onIcon;
    static final long serialVersionUID = 1001L;
    boolean pressOn;
    boolean mouseOn;
    int padLeft;
    int padRight;
    int padTop;
    int padBottom;

    public DToggleButton(String lab) {
        if (lab != null && lab.length() > 0) {
            this.setText(lab);
        }
        this.label = lab;
        this.setFont(new Font("sansserif", 0, 12));
        this.addActionListener(this);
        this.setFocusPainted(false);
        this.addMouseListener(this);
    }

    public void setTooltip(String s) {
        this.setToolTipText(s);
    }

    public void setBg(Color c) {
        this.bgColor = c;
        this.setBackground(c);
    }

    public void setFg(Color c) {
        this.setForeground(c);
    }

    public String toString() {
        return "DToggleButton " + this.label;
    }

    public String getStringIdentifier() {
        return this.label;
    }

    public void setPadding(int p) {
        this.setPadding(p, p, p, p);
    }

    public void actionPerformed(ActionEvent aev) {
        this.pressOn = !this.pressOn;
        this.applyState();
        this.deliverAction(this.pressOn);
    }

    public void setState(boolean b) {
        this.pressOn = b;
        this.applyState();
    }

    public void applyState() {
        Color cbg = this.bgColor;
        Color cbgd = ColorUtil.darker(cbg);
        Color cbgb = ColorUtil.brighter(cbg);
        Border b = null;
        if (this.pressOn) {
            this.setBackground(cbgd);
            b = this.mouseOn ? BorderUtil.makeEtchedUpBorder(cbgd) : BorderUtil.makeSunkenBorder(cbgd, cbg);
        } else {
            this.setBackground(cbg);
            b = this.mouseOn ? BorderUtil.makeEtchedUpBorder(cbg) : BorderUtil.makeRaisedBorder(cbg, cbgb);
        }
        Border bpad = BorderUtil.makeEmptyBorder(this.padLeft, this.padRight, this.padTop, this.padBottom);
        Border btot = BorderUtil.makeCompoundBorder(bpad, b);
        this.setBorder(btot);
        if (this.pressOn) {
            if (this.onIcon != null) {
                this.setIcon(this.onIcon);
            }
        } else if (this.offIcon != null) {
            this.setIcon(this.offIcon);
        }
    }

    public void setOnIcon(ImageIcon icon) {
        this.onIcon = icon;
        if (this.state) {
            this.applyState();
        }
    }

    public void setOffIcon(ImageIcon icon) {
        this.offIcon = icon;
        if (!this.state) {
            this.applyState();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseOn = true;
        this.applyState();
    }

    public void mouseExited(MouseEvent e) {
        this.mouseOn = false;
        this.applyState();
    }

    public void setPadding(int pl, int pr, int pt, int pb) {
        this.padLeft = pl;
        this.padRight = pr;
        this.padTop = pt;
        this.padBottom = pb;
        this.applyState();
    }
}

