/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.interlish.interact.ClickListener;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.util.MouseUtil;

public class DList
extends JList
implements DComponent,
ListSelectionListener,
MouseListener {
    static final long serialVersionUID = 1001L;
    static Font plainfont;
    static Font boldfont;
    public LabelActor labelActor;
    Object bufSel;
    boolean dropEvents = false;
    ClickListener clickListener;
    String[] tooltips;
    int nline = 3;

    public DList() {
        this.setPlainFont();
        this.addListSelectionListener(this);
    }

    public void setTooltip(String s) {
        this.setToolTipText(s);
    }

    public void setBg(Color c) {
        this.setBackground(c);
    }

    public void setTooltips(String[] sa) {
        this.tooltips = sa;
    }

    public void setPlainFont() {
        if (plainfont == null) {
            plainfont = new Font("sansserif", 0, 12);
        }
        this.setFont(plainfont);
    }

    public String getToolTipText(MouseEvent me) {
        int idx = this.locationToIndex(me.getPoint());
        String ret = null;
        if (idx >= 0 && this.tooltips != null && this.tooltips.length > idx) {
            ret = this.tooltips[idx];
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public void setLabelActor(LabelActor la) {
        this.labelActor = la;
    }

    public void valueChanged(ListSelectionEvent lse) {
        Object obj;
        if (!(this.dropEvents || lse != null && lse.getValueIsAdjusting() || (obj = this.getSelectedValue()) == null || obj == this.bufSel || this.labelActor == null)) {
            this.bufSel = obj;
            this.labelActor.labelAction("selected", true);
        }
    }

    public void selectAt(int i) {
        this.dropEvents = true;
        if (i >= 0) {
            this.setSelectedIndex(i);
        } else {
            this.clearSelection();
        }
        this.dropEvents = false;
    }

    public void setClickListener(ClickListener cl) {
        this.clickListener = cl;
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
        if (this.clickListener != null) {
            this.clickListener.pointClicked(e.getX(), e.getY(), MouseUtil.getButton(e));
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void addLine() {
        ++this.nline;
        this.setPreferredSize(new Dimension(100, 20 * this.nline));
    }

    public void removeLine() {
        if (this.nline > 3) {
            --this.nline;
        }
        this.setPreferredSize(new Dimension(100, 20 * this.nline));
    }

    public void ensureHasSelection() {
        if (this.isSelectionEmpty() && this.getModel().getSize() > 0) {
            this.selectAt(0);
            this.valueChanged(null);
        }
    }

    public int listSize() {
        return this.getModel().getSize();
    }
}

