/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JPanel;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.event.TextActor;
import org.catacomb.druid.swing.DTextField;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.report.E;

public class DInt
extends JPanel
implements DComponent,
LabelActor,
TextActor {
    static final long serialVersionUID = 1001L;
    public static final int LOG = 1;
    public static final int LIN = 2;
    public int scale;
    int min0;
    int max0;
    DTextField dTextField;
    LabelActor labelActor;
    int value;
    boolean rangeEditable;

    public DInt(int val, int mn, int mx, String scl) {
        this.setScale(scl);
        this.rangeEditable = true;
        this.setRange(mn, mx);
        String sval = "" + val;
        this.setLayout(new BorderLayout(4, 0));
        this.dTextField = new DTextField(sval, 8);
        this.add("West", this.dTextField);
        this.dTextField.setLineBorder(0xC0C0C0);
        this.dTextField.setTextActor(this);
        this.dTextField.enableReturnEvents();
        this.setRange(mn, mx);
        this.setValue(val);
    }

    public void setProperties(int val, int min, int max, String scale, boolean strictLims) {
        this.setScale(scale);
        this.setRange(min, max);
        this.setValue(val);
        if (strictLims) {
            this.rangeEditable = false;
        }
    }

    public void setTooltip(String s) {
        this.setToolTipText(s);
    }

    private void setScale(String scl) {
        if (scl == null || scl.startsWith("log")) {
            this.scale = 1;
        } else if (scl.startsWith("lin")) {
            this.scale = 2;
        } else {
            E.error(" - unrecognized scale in DFloat " + scl);
            this.scale = 1;
        }
    }

    public void setRange(int min, int max) {
        if (this.rangeEditable) {
            this.min0 = min;
            this.max0 = max;
        } else {
            E.warning("set range called, but range not editable");
        }
    }

    public void setLabel(String s) {
    }

    public void setBg(Color c) {
        this.setBackground(c);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int i) {
        this.setValue(i, null);
    }

    public void setValue(int i, Object src) {
        this.value = i;
        this.showValue();
    }

    public void setFromSlider(int i) {
        this.value = i;
        this.showValue();
        this.notifyValueChange();
    }

    private void showValue() {
        String stxt = "" + this.value;
        this.dTextField.setText(stxt);
    }

    public void notifyValueChange() {
        if (this.labelActor != null) {
            this.labelActor.labelAction("value_changed", true);
        }
    }

    public void setLabelActor(LabelActor lact) {
        this.labelActor = lact;
    }

    public void setEditable(boolean b) {
        this.dTextField.setEditable(b);
    }

    public void labelAction(String s, boolean b) {
        String sval = this.dTextField.getText();
        if (s.equals("accept_text")) {
            try {
                int i = new Integer(sval);
                this.setValue(i);
                this.notifyValueChange();
            }
            catch (Exception ex) {
                E.error(" - not a number " + sval);
            }
        } else if (s.equals("accept_double")) {
            this.notifyValueChange();
        } else {
            E.error("unhandled label action in DFloat " + s);
        }
    }

    public void textChanged(String stxt) {
    }

    public void textEntered(String txt) {
        this.exportFromText();
    }

    public void textEdited(String txt) {
        this.exportFromText();
    }

    private void exportFromText() {
        String sval = this.dTextField.getText();
        try {
            int i = new Integer(sval);
            this.setValue(i);
            this.notifyValueChange();
        }
        catch (Exception ex) {
            E.error(" - not a number " + sval);
        }
    }
}

