/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JPanel;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.event.TextActor;
import org.catacomb.druid.swing.DFloatSlider;
import org.catacomb.druid.swing.DTextField;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.interlish.structure.MouseActor;
import org.catacomb.interlish.structure.MouseSource;
import org.catacomb.report.E;

public class DFloat
extends JPanel
implements DComponent,
LabelActor,
MouseSource,
TextActor {
    static final long serialVersionUID = 1001L;
    public static final int LOG = 1;
    public static final int LIN = 2;
    public int scale;
    double min0;
    double max0;
    DTextField dTextField;
    DFloatSlider dFloatSlider;
    LabelActor labelActor;
    double value;

    public DFloat(double val, double mn, double mx, String scl) {
        this.min0 = mn;
        this.max0 = mx;
        this.setScale(scl);
        this.setLayout(new BorderLayout(4, 0));
        this.dTextField = new DTextField("         ", 8);
        this.add("West", this.dTextField);
        this.dTextField.setLineBorder(0xC0C0C0);
        this.dTextField.setTextActor(this);
        this.dTextField.enableReturnEvents();
        this.dFloatSlider = new DFloatSlider(this, val, mn, mx, this.scale);
        this.dFloatSlider.setLabelActor(this);
        this.add("Center", this.dFloatSlider);
        this.showValue();
        this.dTextField.setTextActor(this);
    }

    public void setTooltip(String s) {
        this.dFloatSlider.setToolTipText(s);
        this.dTextField.setToolTipText(s);
    }

    public void setProperties(double val, double min, double max, String strscl) {
        this.min0 = min;
        this.max0 = max;
        this.setScale(strscl);
        this.dFloatSlider.setRange(this.min0, this.max0);
        this.dFloatSlider.setValue(val);
    }

    private final void setScale(String scl) {
        if (scl == null) {
            this.scale = this.min0 > 0.0 ? 1 : 2;
        } else if (scl.startsWith("log")) {
            this.scale = 1;
        } else if (scl.startsWith("lin")) {
            this.scale = 2;
        } else {
            E.error(" - unrecognized scale in DFloat " + scl);
            this.scale = 1;
        }
        if (this.dFloatSlider != null) {
            this.dFloatSlider.setScale(this.scale);
        }
    }

    public void setMouseActor(MouseActor ma) {
        this.dFloatSlider.setMouseActor(ma);
    }

    public void setLabel(String s) {
        this.dFloatSlider.setLabel(s);
    }

    public void setBg(Color c) {
        this.dFloatSlider.setBg(c);
        this.setBackground(c);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.setValue(d, null);
    }

    public void setValue(double d, Object src) {
        this.value = d;
        this.dFloatSlider.setValue(d);
        this.showValue();
    }

    public void setFromSlider(double d) {
        this.value = d;
        this.showValue();
        this.notifyValueChange();
    }

    private void showValue() {
        this.dTextField.setText(String.format("%.4g", new Double(this.value)));
    }

    public void notifyValueChange() {
        if (this.labelActor != null) {
            this.labelActor.labelAction("value_changed", true);
        }
    }

    public void setLabelActor(LabelActor lact) {
        this.labelActor = lact;
    }

    public void setEditable(boolean b) {
        this.dTextField.setEditable(b);
    }

    private void exportFromText() {
        String sval = this.dTextField.getText();
        try {
            double d = new Double(sval);
            this.setValue(d);
            this.dFloatSlider.setValue(d);
            this.notifyValueChange();
        }
        catch (Exception ex) {
            E.error(" - not a number " + sval);
        }
    }

    public void labelAction(String s, boolean b) {
        if (!s.equals("return_pressed")) {
            if (s.equals("accept_text")) {
                this.exportFromText();
            } else if (s.equals("accept_double")) {
                double d = this.dFloatSlider.getValue();
                this.setValue(d);
                this.showValue();
                this.notifyValueChange();
            } else {
                E.error("unhandled label action in DFloat " + s);
            }
        }
    }

    public void textChanged(String stxt) {
    }

    public void textEntered(String txt) {
        this.exportFromText();
    }

    public void textEdited(String txt) {
        this.exportFromText();
    }
}

