/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.guimodel;

import org.catacomb.interlish.structure.InfoMessage;
import org.catacomb.interlish.util.JUtil;
import org.catacomb.util.Timestamp;

public class LogEntry
implements InfoMessage {
    String timestamp;
    int severity;
    String context;
    String text;
    String logEntryTemplate;
    String htmlText;

    public LogEntry(String s) {
        this(1, "default", s);
    }

    public LogEntry(int level, String msg) {
        this(level, "default", msg);
    }

    public LogEntry(int level, String ctx, String msg) {
        this.severity = level;
        this.context = ctx;
        this.text = msg;
        this.timestamp = Timestamp.withinSessionTimestamp();
    }

    public String getPlainText() {
        return String.valueOf(this.timestamp) + " " + textLevels[this.severity] + " " + this.context + " " + this.text;
    }

    public String getHTML() {
        if (this.htmlText == null) {
            if (this.logEntryTemplate == null) {
                this.logEntryTemplate = JUtil.getRelativeResource(this, "LogEntryTemplate.txt");
            }
            String s = this.logEntryTemplate.replaceAll("LEVEL", textLevels[this.severity]);
            s = s.replaceAll("TIMESTAMP", this.timestamp);
            s = s.replaceAll("CONTEXT", this.context);
            this.htmlText = s = s.replaceAll("TEXT", this.text);
        }
        return this.htmlText;
    }

    public int getLevel() {
        return this.severity;
    }

    public String getContext() {
        return this.context;
    }

    public boolean sameAs(InfoMessage im) {
        LogEntry le;
        boolean ret = false;
        if (im instanceof LogEntry && (le = (LogEntry)im).getPlainText().equals(this.getPlainText())) {
            ret = true;
        }
        return ret;
    }
}

