/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.guimodel;

import java.util.ArrayList;
import org.catacomb.druid.guimodel.LogEntry;
import org.catacomb.interlish.report.UserLog;
import org.catacomb.interlish.structure.InfoLog;
import org.catacomb.interlish.structure.InfoMessage;
import org.catacomb.interlish.structure.LogNotificand;
import org.catacomb.report.E;

public class Log
implements InfoLog {
    String name;
    ArrayList<InfoMessage> messages;
    StringBuffer textBuffer;
    StringBuffer htmlBuffer;
    LogNotificand notificand;
    static Log systemLog;

    public Log(String s) {
        this.name = s;
        this.messages = new ArrayList();
        this.clear();
    }

    public void addInfoMessage(InfoMessage im) {
        this.messages.add(im);
        this.textBuffer.append(im.getPlainText());
        this.textBuffer.append("-br-");
        this.textBuffer.append("\n");
        this.htmlBuffer.append(im.getHTML());
        if (this.notificand != null) {
            this.notificand.itemLogged(this);
        }
    }

    public void addInfoMessage(int lev, String ctx, String msg) {
        this.addInfoMessage(new LogEntry(lev, ctx, msg));
    }

    public void setLogNotificand(LogNotificand ln) {
        if (this.notificand != null) {
            E.warning("squashing existing log notificand");
        }
        this.notificand = ln;
    }

    public void removeLogNotificand(LogNotificand ln) {
        this.notificand = null;
    }

    public String getPlainText() {
        return this.textBuffer.toString();
    }

    public String getHTML() {
        return this.htmlBuffer.toString();
    }

    public void clear() {
        this.messages.clear();
        this.textBuffer = new StringBuffer();
        this.htmlBuffer = new StringBuffer();
    }

    public static void setSystemLog(Log log) {
        systemLog = log;
        UserLog.setLog(log);
        E.setReporter(log);
    }

    public void report(String s) {
        Log.infoMsg("", s);
    }

    public void reportInfo(String s) {
        Log.infoMsg("", s);
    }

    public void reportWarning(String s) {
        Log.warningMsg("", s);
    }

    public void reportError(String s) {
        Log.errorMsg("", s);
    }

    public static void infoMsg(String ctx, String txt) {
        systemLog.addInfoMessage(1, ctx, txt);
    }

    public static void warningMsg(String ctx, String txt) {
        systemLog.addInfoMessage(2, ctx, txt);
    }

    public static void errorMsg(String ctx, String txt) {
        systemLog.addInfoMessage(3, ctx, txt);
    }
}

