/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import java.util.ArrayList;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.gui.edit.DruMenuButton;
import org.catacomb.druid.gui.edit.DruMenuItem;
import org.catacomb.druid.swing.DMenu;
import org.catacomb.druid.swing.DMenuItem;
import org.catacomb.interlish.structure.ActionRelay;
import org.catacomb.interlish.structure.ActionSource;
import org.catacomb.interlish.structure.PopulableMenu;
import org.catacomb.interlish.structure.Syncable;
import org.catacomb.interlish.structure.TreeNode;
import org.catacomb.report.E;
import org.catacomb.util.StringTree;
import org.catacomb.util.StringTreeLeaf;
import org.catacomb.util.StringUtil;

public class DruMenu
implements PopulableMenu,
ActionSource,
LabelActor,
Syncable {
    static final long serialVersionUID = 1001L;
    String name;
    String id;
    DruMenu parentMenu;
    protected String methodName;
    ActionRelay actionRelay;
    ArrayList<Syncable> items;
    DMenu dMenu;

    public DruMenu(String s) {
        this.dMenu = new DMenu(s);
        this.name = s;
        this.items = new ArrayList();
        this.dMenu.applyRollover();
    }

    public DMenu getGUIPeer() {
        return this.dMenu;
    }

    void setParentMenu(DruMenu dm) {
        this.parentMenu = dm;
    }

    public String toString() {
        return "DruMenu " + this.name;
    }

    public String getID() {
        return this.id;
    }

    public void addSubMenu(DruMenu dsm) {
        this.items.add(dsm);
        this.dMenu.add(dsm.getGUIPeer());
        dsm.setParentMenu(this);
    }

    public void addItem(DruMenuItem dmi) {
        this.items.add(dmi);
        this.dMenu.add(dmi.getGUIPeer());
    }

    public void addItem(String s) {
        DMenuItem dmi = new DMenuItem(s);
        this.dMenu.add(dmi);
        dmi.setLabelActor(this);
    }

    public void addItem(String lab, String val) {
        DMenuItem dmi = new DMenuItem(lab, val);
        this.dMenu.add(dmi);
        dmi.setLabelActor(this);
    }

    public void setBg(Color background) {
        this.dMenu.setBackground(background);
    }

    public void setFg(Color foreground) {
        this.dMenu.setForeground(foreground);
    }

    public void setAction(String s) {
        this.methodName = s;
    }

    public boolean hasRelay() {
        return this.actionRelay != null;
    }

    public void setActionRelay(ActionRelay ac) {
        this.actionRelay = ac;
    }

    public void labelAction(String s, boolean b) {
        if (this.actionRelay != null) {
            this.actionRelay.actionS(this.methodName, s);
        } else if (this.parentMenu != null) {
            this.parentMenu.labelAction(s, b);
        } else {
            E.warning("dropped menu action " + s);
        }
    }

    public void setOptions(String[] sa) {
        this.setItems(sa);
    }

    public void setItems(String[] sa) {
        this.dMenu.removeAll();
        if (sa == null || sa.length == 0) {
            this.dMenu.setEnabled(false);
        } else {
            this.dMenu.setEnabled(true);
            int i = 0;
            while (i < sa.length) {
                this.addItem(sa[i]);
                ++i;
            }
        }
    }

    public void setItemsTree(String[] sa) {
        this.dMenu.removeAll();
        StringTree stree = StringUtil.flatTreeify(sa, "root");
        for (TreeNode obj : stree.getChildren()) {
            if (obj instanceof String) {
                this.addItem((String)((Object)obj), (String)((Object)obj));
                continue;
            }
            if (obj instanceof StringTree) {
                this.addSubMenu(this.makeMenu((StringTree)obj));
                continue;
            }
            if (obj instanceof StringTreeLeaf) {
                String stln = ((StringTreeLeaf)obj).getLabel();
                this.addItem(stln, stln);
                continue;
            }
            E.error("unkown item " + obj);
        }
    }

    private DruMenu makeMenu(StringTree stree) {
        DruMenu dm = new DruMenu(stree.getLabel());
        for (TreeNode obj : stree.getChildren()) {
            if (obj instanceof String) {
                dm.addItem((String)((Object)obj), String.valueOf(stree.getPath()) + obj);
                continue;
            }
            if (obj instanceof StringTreeLeaf) {
                StringTreeLeaf stl = (StringTreeLeaf)obj;
                dm.addItem(stl.getLabel(), String.valueOf(stree.getPath()) + stl.getLabel());
                continue;
            }
            if (obj instanceof StringTree) {
                dm.addSubMenu(this.makeMenu((StringTree)obj));
                continue;
            }
            E.error("unkown item " + obj);
        }
        return dm;
    }

    public void addSeparator() {
        this.dMenu.addSeparator();
    }

    public void setID(String s) {
        this.id = s;
    }

    public void preShowSync() {
        this.sync();
    }

    public void sync() {
        for (Syncable sbl : this.items) {
            sbl.sync();
        }
    }

    public void showPopup(DruMenuButton button, int i, int j) {
        this.dMenu.showPopup(button.getGUIPeer(), i, j);
    }
}

