/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import java.awt.Dimension;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.swing.DHTMLPane;
import org.catacomb.druid.swing.DScrollPane;
import org.catacomb.interlish.structure.Consumer;
import org.catacomb.interlish.structure.InfoLog;
import org.catacomb.interlish.structure.LogDisplay;
import org.catacomb.interlish.structure.LogNotificand;
import org.catacomb.interlish.util.JUtil;
import org.catacomb.report.E;
import org.catacomb.xdoc.XdocBase;

public class DruLogPanel
extends DruGCPanel
implements LogNotificand,
Consumer,
LogDisplay,
Runnable {
    static final long serialVersionUID = 1001L;
    DScrollPane dsp;
    DHTMLPane htmlPane;
    InfoLog infoLog;
    String logHTMLTemplate;
    Thread updateThread;
    boolean pendingEntry = false;

    public DruLogPanel(int h) {
        this.setBorderLayout(2, 2);
        this.dsp = new DScrollPane();
        this.dsp.setVerticalScrollBarAlways();
        this.addDComponent(this.dsp, "Center");
        this.htmlPane = new DHTMLPane();
        this.htmlPane.setRelStyleSheet(new XdocBase(), "LogCSS.txt");
        this.dsp.setViewportView(this.htmlPane);
        this.setTooltipTarget(this.htmlPane);
    }

    public String getLogHTMLTemplate() {
        if (this.logHTMLTemplate == null) {
            this.logHTMLTemplate = JUtil.getRelativeResource(new XdocBase(), "LogHTMLTemplate.txt");
        }
        return this.logHTMLTemplate;
    }

    public void addInfoLog(InfoLog ilog) {
        if (this.infoLog != null) {
            E.warning("squashing existing log");
            this.infoLog.removeLogNotificand(this);
        }
        this.infoLog = ilog;
        this.infoLog.setLogNotificand(this);
    }

    public void setPreferredSize(int w, int h) {
        this.dsp.setPreferredSize(new Dimension(w, h));
        this.setPreferredSize(new Dimension(w, h));
    }

    public void setBg(Color c) {
        this.dsp.setBg(c);
        this.htmlPane.setBg(c);
        super.setBg(c);
    }

    public void setNoHorizontalScroll() {
        this.dsp.setHorizontalScrollbarNever();
    }

    public void clear() {
        if (this.infoLog != null) {
            this.infoLog.clear();
            this.showHTML("");
        }
    }

    public void save() {
        E.missing();
    }

    public void itemLogged(InfoLog ilog) {
        if (this.infoLog != ilog) {
            E.error("log mixup?");
        }
        this.pendingEntry = true;
        if (this.updateThread == null) {
            this.updateThread = new Thread(this);
            this.updateThread.setPriority(1);
            this.updateThread.start();
        }
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(2000L);
                if (!this.pendingEntry) continue;
                this.pendingEntry = false;
                String sh = this.infoLog.getHTML();
                this.showHTML(sh);
            }
        }
        catch (Exception ex) {
            E.info("thread died?");
            return;
        }
    }

    public void showHTML(String s) {
        if (s == null) {
            s = "";
        }
        String txt = this.getLogHTMLTemplate();
        txt = txt.replaceAll("BODY", s);
        this.htmlPane.showHTML(txt);
    }

    public void showText(String s) {
        if (s == null) {
            s = "";
        }
        s = s.replaceAll("-p-", "</p>\n<p>");
        s = s.replaceAll("-br-", "<br>\n");
        String sh = "<p>" + s + "</p>";
        this.htmlPane.showHTML(sh);
    }
}

