/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import java.util.ArrayList;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.gui.base.DruListCellRenderer;
import org.catacomb.druid.gui.base.DruListClickActor;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.swing.DList;
import org.catacomb.druid.util.ListDisplay;
import org.catacomb.interlish.content.KeyedList;
import org.catacomb.interlish.interact.ClickListener;
import org.catacomb.interlish.structure.IDd;
import org.catacomb.interlish.structure.List;
import org.catacomb.interlish.structure.ListWatcher;
import org.catacomb.report.E;
import org.catacomb.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DruListPanel
extends DruGCPanel
implements ListDisplay,
LabelActor,
ClickListener,
ListWatcher,
List {
    static final long serialVersionUID = 1001L;
    public static final int NORMAL_ORDER = 100;
    public static final int REVERSE_ORDER = 101;
    int order = 100;
    int nrow;
    DList dList;
    Object[] items;
    String[] tooltips;
    ArrayList<DruListClickActor> clickActors;
    KeyedList<? extends IDd> targetKL;

    public DruListPanel() {
        this(10);
    }

    public DruListPanel(int nr) {
        this.nrow = nr;
        this.dList = new DList();
        this.addSingleDComponent(this.dList);
        String[] sa = new String[]{};
        this.dList.setListData(sa);
        this.dList.setLabelActor(this);
    }

    public void setItems(Object[] sa) {
        if (sa == null) {
            sa = new String[]{};
        }
        this.items = sa;
        this.dList.setListData(sa);
    }

    @Override
    public void setItems(ArrayList<? extends Object> obal) {
        Object[] obar = new Object[obal.size()];
        String[] ott = new String[obal.size()];
        int iel = 0;
        for (Object object : obal) {
            if (object instanceof String[]) {
                String[] sp = (String[])object;
                obar[iel] = sp[0];
                if (sp.length > 1) {
                    ott[iel] = sp[1];
                }
            } else {
                obar[iel] = object;
            }
            ++iel;
        }
        this.items = obar;
        this.tooltips = ott;
        this.dList.setListData(obar);
        this.dList.setTooltips(this.tooltips);
    }

    @Override
    public void setBg(Color c) {
        this.setEtchedBorder(c);
        super.setBg(c);
    }

    public void setCellRenderer(DruListCellRenderer obj) {
        this.dList.setCellRenderer(obj.getGUIPeer());
    }

    @Override
    public void updateDisplay() {
        this.dList.repaint();
    }

    public Object getSelectedItem() {
        return this.dList.getSelectedValue();
    }

    public int getSelectedIndex() {
        return this.dList.getSelectedIndex();
    }

    public String getSelectedName() {
        return "" + this.getSelectedItem();
    }

    @Override
    public void labelAction(String s, boolean b) {
        if (s.equals("selected")) {
            String ssel = this.getSelectedName();
            this.valueChange(ssel);
        }
    }

    public void clear() {
        this.dList.setListData(new String[0]);
    }

    public void selectAt(int i) {
        this.dList.selectAt(i);
    }

    public void setSelectedItem(Object obj) {
        this.setSelected(obj);
    }

    @Override
    public void setSelected(Object obj) {
        int isel = -1;
        if (obj != null) {
            int i = 0;
            while (i < this.items.length) {
                if (obj.equals(this.items[i])) {
                    isel = i;
                    break;
                }
                ++i;
            }
            if (isel < 0) {
                E.warning(" not in list " + obj);
            }
        }
        this.dList.selectAt(isel);
    }

    public void addClickAction(DruListClickActor actor) {
        if (this.clickActors == null) {
            this.clickActors = new ArrayList();
            this.dList.setClickListener(this);
        }
        this.clickActors.add(actor);
    }

    @Override
    public void pointClicked(int x, int y, int b) {
        if (this.clickActors != null) {
            for (DruListClickActor ca : this.clickActors) {
                ca.clicked(x, this);
            }
        }
    }

    @Override
    public void setKeyedList(KeyedList<? extends IDd> idkl) {
        if (this.targetKL != null) {
            this.targetKL.removeListWatcher(this);
        }
        this.targetKL = idkl;
        this.targetKL.addListWatcher(this);
        this.syncFromKeyedList();
    }

    private void syncFromKeyedList() {
        Object osel = this.getSelectedItem();
        ArrayList<String> als = this.targetKL.getKeys();
        Object[] sa = als.toArray(new String[0]);
        if (this.order == 101) {
            sa = ArrayUtil.reverseStringArray((String[])sa);
        }
        this.setItems(sa);
        if (osel != null) {
            this.setSelectedItem(osel);
        } else {
            this.setSelectedItem(null);
        }
    }

    @Override
    public void listChanged(Object src) {
        if (this.targetKL != null) {
            this.syncFromKeyedList();
        }
    }

    public void addLine() {
        this.dList.addLine();
    }

    public void removeLine() {
        this.dList.removeLine();
    }

    public void ensureHasSelection() {
        this.dList.ensureHasSelection();
    }

    public boolean isSelectionEmpty() {
        return this.dList.isSelectionEmpty();
    }

    public int listSize() {
        return this.dList.listSize();
    }

    @Override
    public void able(boolean b) {
        E.missing();
    }

    public void setOrder(int ord) {
        this.order = ord;
    }
}

