/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import org.catacomb.druid.event.TextActor;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.gui.edit.ExpandingTextAreaController;
import org.catacomb.druid.swing.DButton;
import org.catacomb.druid.swing.DPanel;
import org.catacomb.druid.swing.DTextArea;
import org.catacomb.interlish.content.StringValue;
import org.catacomb.interlish.structure.Ablable;
import org.catacomb.interlish.structure.TextArea;
import org.catacomb.interlish.structure.Value;
import org.catacomb.interlish.structure.ValueWatcher;
import org.catacomb.report.E;

public class DruExpandingTextArea
extends DruGCPanel
implements TextActor,
Ablable,
TextArea,
ValueWatcher {
    static final long serialVersionUID = 1001L;
    DTextArea dTextArea;
    DPanel rtPanel;
    DPanel rbPanel;
    DButton upButton;
    DButton downButton;
    StringValue stringValue;
    boolean collapsed;
    boolean autoResize = false;

    public DruExpandingTextArea(String mn, int width, int height) {
        this.setBorderLayout(0, 0);
        this.setActionMethod(mn);
        this.dTextArea = new DTextArea(width, height, 2);
        this.addDComponent(this.dTextArea, "Center");
        this.rtPanel = new DPanel();
        this.rtPanel.setLayout(new BorderLayout());
        this.rbPanel = new DPanel();
        this.rbPanel.setLayout(new GridLayout(2, 1, 2, 2));
        this.rtPanel.add((Component)this.rbPanel, "North");
        this.upButton = new DButton("");
        this.upButton.setActionCommand("remove");
        this.upButton.setIconSource("up-hat.gif");
        this.upButton.setPadding(2, 2, 2, 2);
        this.downButton = new DButton("");
        this.downButton.setActionCommand("add");
        this.downButton.setIconSource("down-hat.gif");
        this.downButton.setPadding(2, 2, 2, 2);
        this.rbPanel.add(this.upButton);
        this.rbPanel.add(this.downButton);
        this.addDComponent(this.rtPanel, "West");
        ExpandingTextAreaController etac = new ExpandingTextAreaController(this.dTextArea);
        this.upButton.setLabelActor(etac);
        this.downButton.setLabelActor(etac);
        this.dTextArea.setTextActor(this);
        this.setLineBorder(0xC0C0C0);
        this.collapsed = false;
    }

    public void collapse() {
        if (!this.collapsed) {
            this.removeDComponent(this.dTextArea);
            this.removeDComponent(this.rtPanel);
            this.collapsed = true;
        }
    }

    public void uncollapse() {
        if (this.collapsed) {
            this.addDComponent(this.dTextArea, "Center");
            this.addDComponent(this.rtPanel, "West");
            this.collapsed = false;
        }
    }

    public void valueChangedBy(Value pv, Object src) {
        if (src != this) {
            if (this.stringValue == pv) {
                if (this.stringValue == null) {
                    this.dTextArea.setText("");
                    this.dTextArea.setEnabled(false);
                } else {
                    this.dTextArea.setText(this.stringValue.getString());
                    if (this.autoResize) {
                        this.dTextArea.resizeUpToText();
                    }
                    if (src.equals("HIGHLIGHT")) {
                        this.dTextArea.highlightLine(this.stringValue.getHighlight());
                    } else {
                        this.dTextArea.clearHighlight();
                    }
                }
            } else {
                E.error("value changed by called with mismatched value");
            }
        }
    }

    public void setStringValue(StringValue sv) {
        if (this.stringValue != null) {
            this.stringValue.removeValueWatcher(this);
        }
        this.stringValue = sv;
        if (this.stringValue == null) {
            this.dTextArea.setEnabled(false);
        } else {
            this.dTextArea.setText(this.stringValue.getString());
            this.stringValue.addValueWatcher(this);
            if (this.autoResize) {
                this.dTextArea.resizeUpToText();
            }
        }
    }

    public void textChanged(String s) {
        this.stringValue.reportableSetString(this.dTextArea.getText(), this);
        if (this.autoResize) {
            this.dTextArea.resizeUpToText();
        }
    }

    public void textEntered(String s) {
        E.info("text entered");
    }

    public void textEdited(String s) {
    }

    public void setBg(Color c) {
        this.rtPanel.setBg(c);
        this.rbPanel.setBg(c);
        this.upButton.setBg(c);
        this.downButton.setBg(c);
        super.setBg(c);
    }

    public void setTextBg(int icol) {
        Color c = new Color(icol);
        this.dTextArea.setBg(c);
    }

    public void setLineBorder(int icol) {
        this.dTextArea.setLineBorder(icol);
    }

    public void able(boolean b) {
        this.dTextArea.setEnabled(b);
    }

    public void setEditable(boolean b) {
        this.dTextArea.setEditable(b);
        this.dTextArea.setEnabled(b);
    }

    public void setAntialiased() {
        this.dTextArea.setAntialiased();
    }

    public void setPadding(int padding) {
        this.dTextArea.setPadding(padding);
    }

    public void setFontSize(int fs) {
        this.dTextArea.setFontSize(fs);
    }

    public void setAutoResize(boolean b) {
        this.autoResize = b;
    }
}

