/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.swing.DButton;
import org.catacomb.druid.swing.DColorChooser;
import org.catacomb.druid.swing.DLabel;
import org.catacomb.interlish.content.ColorValue;
import org.catacomb.interlish.structure.Ablable;
import org.catacomb.interlish.structure.ColorValueEditor;
import org.catacomb.interlish.structure.Value;
import org.catacomb.interlish.structure.ValueWatcher;
import org.catacomb.report.E;
import org.catacomb.util.ColorUtil;

public class DruColorChoice
extends DruGCPanel
implements LabelActor,
Ablable,
ColorValueEditor,
ValueWatcher {
    static final long serialVersionUID = 1001L;
    DLabel dLabel;
    DButton dButton;
    ColorValue colorValue;
    Color currentColor;
    String label;
    public LabelActor labelActor;

    public DruColorChoice(String lab, String mnm) {
        this.label = lab;
        this.methodName = mnm;
        this.setFlowLeft(2, 2);
        this.dLabel = new DLabel(this.label);
        this.dButton = new DButton("   ");
        this.dButton.setActionCommand("select");
        this.addDComponent(this.dButton);
        this.addDComponent(this.dLabel);
        this.dButton.setLabelActor(this);
        this.dButton.applyRollover();
        this.setColorValue(new ColorValue("#b0b000"));
        this.currentColor = new Color(this.colorValue.getIntColor());
        this.setTooltipTarget(this.dButton);
    }

    public void valueChangedBy(Value pv, Object src) {
        if (src == this) {
            this.setColor(new Color(this.colorValue.getIntColor()));
            this.valueChange(this.currentColor);
        } else if (this.colorValue == pv) {
            if (this.colorValue == null) {
                this.setColor(Color.red);
            } else {
                this.setColor(new Color(this.colorValue.getIntColor()));
            }
        } else {
            E.error("value changed by called with mismatched value");
        }
    }

    public void setColorValue(ColorValue cv) {
        if (this.colorValue != null) {
            this.colorValue.removeValueWatcher(this);
        }
        this.colorValue = cv;
        if (this.colorValue == null) {
            this.dButton.setEnabled(false);
        } else {
            this.dButton.setEnabled(true);
            this.setColor(new Color(this.colorValue.getIntColor()));
            this.colorValue.addValueWatcher(this);
        }
    }

    public void labelAction(String s, boolean b) {
        if (s.equals("select")) {
            Color newColor = DColorChooser.showDialog(null, this.label, this.currentColor);
            if (newColor != null) {
                this.colorValue.reportableSetColor(newColor.getRGB(), (Object)this);
            }
        } else {
            E.warning("unhandled action " + s);
        }
    }

    public void setBg(Color c) {
        this.dLabel.setBg(c);
        super.setBg(c);
    }

    public void postApply() {
        this.dButton.setMouseActor(this);
    }

    public void able(boolean b) {
        this.dButton.setEnabled(b);
        this.dLabel.setEnabled(b);
    }

    public void setColor(Color c) {
        if (c == null) {
            c = Color.gray;
        }
        this.currentColor = c;
        this.dButton.setBg(c);
    }

    public Color getColor() {
        return this.currentColor;
    }

    public String getStringValue() {
        return ColorUtil.serializeColor(this.currentColor);
    }
}

